/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics;

import com.sonicether.soundphysics.Loggers;
import com.sonicether.soundphysics.ReflectedAudio;
import com.sonicether.soundphysics.SoundPhysicsMod;
import com.sonicether.soundphysics.config.ReverbParams;
import com.sonicether.soundphysics.debug.RaycastRenderer;
import com.sonicether.soundphysics.profiling.TaskProfiler;
import com.sonicether.soundphysics.utils.LevelAccessUtils;
import com.sonicether.soundphysics.utils.RaycastUtils;
import com.sonicether.soundphysics.world.ClientLevelProxy;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.EXTEfx;

public class SoundPhysics {
    private static final float PHI = 1.618034f;
    private static final Pattern AMBIENT_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\-\\.]+:ambient\\..*$");
    private static final Pattern BLOCK_PATTERN = Pattern.compile(".*block..*");
    private static final Pattern VOICECHAT_PATTERN = Pattern.compile("^voicechat:.*$");
    private static int auxFXSlot0;
    private static int auxFXSlot1;
    private static int auxFXSlot2;
    private static int auxFXSlot3;
    private static int reverb0;
    private static int reverb1;
    private static int reverb2;
    private static int reverb3;
    private static int directFilter0;
    private static int sendFilter0;
    private static int sendFilter1;
    private static int sendFilter2;
    private static int sendFilter3;
    private static Minecraft minecraft;
    private static TaskProfiler profiler;
    private static SoundSource lastSoundCategory;
    private static String lastSoundName;
    private static int maxAuxSends;

    public static void init() {
        Loggers.log("Initializing Sound Physics", new Object[0]);
        SoundPhysics.setupEFX();
        Loggers.log("EFX ready", new Object[0]);
        minecraft = Minecraft.m_91087_();
        profiler = new TaskProfiler("Sound Physics");
    }

    public static void syncReverbParams() {
        if (auxFXSlot0 != 0) {
            SoundPhysics.setReverbParams(ReverbParams.getReverb0(), auxFXSlot0, reverb0);
            SoundPhysics.setReverbParams(ReverbParams.getReverb1(), auxFXSlot1, reverb1);
            SoundPhysics.setReverbParams(ReverbParams.getReverb2(), auxFXSlot2, reverb2);
            SoundPhysics.setReverbParams(ReverbParams.getReverb3(), auxFXSlot3, reverb3);
        }
    }

    static void setupEFX() {
        long currentContext = ALC10.alcGetCurrentContext();
        long currentDevice = ALC10.alcGetContextsDevice((long)currentContext);
        if (!ALC10.alcIsExtensionPresent((long)currentDevice, (CharSequence)"ALC_EXT_EFX")) {
            Loggers.error("EFX Extension not found on current device. Aborting.", new Object[0]);
            return;
        }
        Loggers.log("EFX Extension recognized", new Object[0]);
        maxAuxSends = ALC10.alcGetInteger((long)currentDevice, (int)131075);
        Loggers.log("Max auxiliary sends: {}", maxAuxSends);
        auxFXSlot0 = EXTEfx.alGenAuxiliaryEffectSlots();
        Loggers.log("Aux slot {} created", auxFXSlot0);
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot0, (int)3, (int)1);
        auxFXSlot1 = EXTEfx.alGenAuxiliaryEffectSlots();
        Loggers.log("Aux slot {} created", auxFXSlot1);
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot1, (int)3, (int)1);
        auxFXSlot2 = EXTEfx.alGenAuxiliaryEffectSlots();
        Loggers.log("Aux slot {} created", auxFXSlot2);
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot2, (int)3, (int)1);
        auxFXSlot3 = EXTEfx.alGenAuxiliaryEffectSlots();
        Loggers.log("Aux slot {} created", auxFXSlot3);
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot3, (int)3, (int)1);
        Loggers.logALError("Failed creating auxiliary effect slots");
        reverb0 = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)reverb0, (int)32769, (int)32768);
        Loggers.logALError("Failed creating reverb effect slot 0");
        reverb1 = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)reverb1, (int)32769, (int)32768);
        Loggers.logALError("Failed creating reverb effect slot 1");
        reverb2 = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)reverb2, (int)32769, (int)32768);
        Loggers.logALError("Failed creating reverb effect slot 2");
        reverb3 = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)reverb3, (int)32769, (int)32768);
        Loggers.logALError("Failed creating reverb effect slot 3");
        directFilter0 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)directFilter0, (int)32769, (int)1);
        Loggers.logDebug("directFilter0: {}", directFilter0);
        sendFilter0 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)sendFilter0, (int)32769, (int)1);
        Loggers.logDebug("filter0: {}", sendFilter0);
        sendFilter1 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)sendFilter1, (int)32769, (int)1);
        Loggers.logDebug("filter1: {}", sendFilter1);
        sendFilter2 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)sendFilter2, (int)32769, (int)1);
        Loggers.logDebug("filter2: {}", sendFilter2);
        sendFilter3 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)sendFilter3, (int)32769, (int)1);
        Loggers.logDebug("filter3: {}", sendFilter3);
        Loggers.logALError("Error creating lowpass filters");
        SoundPhysics.syncReverbParams();
    }

    public static void setLastSoundCategoryAndName(SoundSource sc, String name) {
        lastSoundCategory = sc;
        lastSoundName = name;
    }

    public static void onPlaySound(double posX, double posY, double posZ, int sourceID) {
        SoundPhysics.processSound(sourceID, posX, posY, posZ, lastSoundCategory, lastSoundName, false);
    }

    public static void onPlayReverb(double posX, double posY, double posZ, int sourceID) {
        SoundPhysics.processSound(sourceID, posX, posY, posZ, lastSoundCategory, lastSoundName, true);
    }

    public static Vec3 processSound(int source, double posX, double posY, double posZ, SoundSource category, String sound) {
        return SoundPhysics.processSound(source, posX, posY, posZ, category, sound, false);
    }

    @Nullable
    public static Vec3 processSound(int source, double posX, double posY, double posZ, SoundSource category, String sound, boolean auxOnly) {
        if (!SoundPhysicsMod.CONFIG.enabled.get().booleanValue()) {
            return null;
        }
        Loggers.logDebug("Playing sound with source id '{}', position x:{}, y:{}, z:{}, \tcategory: '{}' \tname: '{}'", source, posX, posY, posZ, category.toString(), sound);
        TaskProfiler.TaskProfilerHandle profile = profiler.profile();
        Vec3 newPos = SoundPhysics.evaluateEnvironment(source, posX, posY, posZ, category, sound, auxOnly);
        profile.finish();
        Loggers.logProfiling("Evaluated environment for sound {} in {} ms", sound, profile.getDuration());
        profiler.onTally(() -> profiler.logResults());
        return newPos;
    }

    @Nullable
    private static Vec3 evaluateEnvironment(int sourceID, double posX, double posY, double posZ, SoundSource category, String sound, boolean auxOnly) {
        int i;
        LocalPlayer player = SoundPhysics.minecraft.f_91074_;
        ClientLevel level = SoundPhysics.minecraft.f_91073_;
        if (player == null || level == null || posX == 0.0 && posY == 0.0 && posZ == 0.0) {
            SoundPhysics.setDefaultEnvironment(sourceID, auxOnly);
            return null;
        }
        if (!SoundPhysicsMod.CONFIG.updateMovingSounds.get().booleanValue() && category == SoundSource.RECORDS) {
            SoundPhysics.setDefaultEnvironment(sourceID, auxOnly);
            return null;
        }
        if (!SoundPhysicsMod.ALLOWED_SOUND_CONFIG.isAllowed(sound)) {
            SoundPhysics.setDefaultEnvironment(sourceID, auxOnly);
            return null;
        }
        if (!SoundPhysicsMod.CONFIG.evaluateAmbientSounds.get().booleanValue() && SoundPhysics.isAmbientSound(sound)) {
            SoundPhysics.setDefaultEnvironment(sourceID, auxOnly);
            return null;
        }
        float absorptionCoeff = (float)((double)SoundPhysicsMod.CONFIG.blockAbsorption.get().floatValue() * 3.0);
        Vec3 playerPos = SoundPhysics.minecraft.f_91063_.m_109153_().m_90583_();
        Vec3 soundPos = new Vec3(posX, posY, posZ);
        Vec3 normalToPlayer = playerPos.m_82546_(soundPos).m_82541_();
        BlockPos soundBlockPos = new BlockPos((int)soundPos.f_82479_, (int)soundPos.f_82480_, (int)soundPos.f_82481_);
        Loggers.logDebug("Player pos: {}, {}, {} \tSound Pos: {}, {}, {} \tTo player vector: {}, {}, {}", playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, soundPos.f_82479_, soundPos.f_82480_, soundPos.f_82481_, normalToPlayer.f_82479_, normalToPlayer.f_82480_, normalToPlayer.f_82481_);
        double occlusionAccumulation = SoundPhysics.calculateOcclusion(soundPos, playerPos, category, sound);
        float directCutoff = (float)Math.exp(-occlusionAccumulation * (double)absorptionCoeff);
        float directGain = auxOnly ? 0.0f : (float)Math.pow(directCutoff, 0.1);
        Loggers.logOcclusion("Direct cutoff: {}, direct gain: {}", Float.valueOf(directCutoff), Float.valueOf(directGain));
        float sendGain0 = 0.0f;
        float sendGain1 = 0.0f;
        float sendGain2 = 0.0f;
        float sendGain3 = 0.0f;
        float sendCutoff0 = 1.0f;
        float sendCutoff1 = 1.0f;
        float sendCutoff2 = 1.0f;
        float sendCutoff3 = 1.0f;
        if (SoundPhysics.minecraft.f_91074_.m_5842_()) {
            directCutoff *= 1.0f - SoundPhysicsMod.CONFIG.underwaterFilter.get().floatValue();
        }
        float maxDistance = 256.0f;
        int numRays = SoundPhysicsMod.CONFIG.environmentEvaluationRayCount.get();
        int rayBounces = SoundPhysicsMod.CONFIG.environmentEvaluationRayBounces.get();
        ReflectedAudio audioDirection = new ReflectedAudio(occlusionAccumulation, sound);
        float[] bounceReflectivityRatio = new float[rayBounces];
        float rcpTotalRays = 1.0f / (float)(numRays * rayBounces);
        float gAngle = 10.166408f;
        Vec3 directSharedAirspaceVector = SoundPhysics.getSharedAirspace(soundPos, playerPos);
        if (directSharedAirspaceVector != null) {
            audioDirection.addDirectAirspace(directSharedAirspaceVector);
        }
        block0: for (i = 0; i < numRays; ++i) {
            float fiN = (float)i / (float)numRays;
            float longitude = gAngle * (float)i * 1.0f;
            float latitude = (float)Math.asin(fiN * 2.0f - 1.0f);
            Vec3 rayDir = new Vec3(Math.cos(latitude) * Math.cos(longitude), Math.cos(latitude) * Math.sin(longitude), Math.sin(latitude));
            Vec3 rayEnd = new Vec3(soundPos.f_82479_ + rayDir.f_82479_ * (double)maxDistance, soundPos.f_82480_ + rayDir.f_82480_ * (double)maxDistance, soundPos.f_82481_ + rayDir.f_82481_ * (double)maxDistance);
            BlockHitResult rayHit = RaycastUtils.rayCast(SoundPhysics.getLevelProxy(), soundPos, rayEnd, soundBlockPos);
            if (rayHit.m_6662_() != HitResult.Type.BLOCK) continue;
            double rayLength = soundPos.m_82554_(rayHit.m_82450_());
            BlockPos lastHitBlock = rayHit.m_82425_();
            Vec3 lastHitPos = rayHit.m_82450_();
            Vec3 lastHitNormal = new Vec3(rayHit.m_82434_().m_253071_());
            Vec3 lastRayDir = rayDir;
            float totalRayDistance = (float)rayLength;
            RaycastRenderer.addSoundBounceRay(soundPos, rayHit.m_82450_(), ChatFormatting.GREEN.m_126665_());
            Vec3 firstSharedAirspaceVector = SoundPhysics.getSharedAirspace(rayHit, playerPos);
            if (firstSharedAirspaceVector != null) {
                audioDirection.addSharedAirspace(firstSharedAirspaceVector, totalRayDistance);
            }
            for (int j = 0; j < rayBounces; ++j) {
                Vec3 newRayDir = SoundPhysics.reflect(lastRayDir, lastHitNormal);
                Vec3 newRayStart = lastHitPos;
                Vec3 newRayEnd = new Vec3(newRayStart.f_82479_ + newRayDir.f_82479_ * (double)maxDistance, newRayStart.f_82480_ + newRayDir.f_82480_ * (double)maxDistance, newRayStart.f_82481_ + newRayDir.f_82481_ * (double)maxDistance);
                BlockHitResult newRayHit = RaycastUtils.rayCast(SoundPhysics.getLevelProxy(), newRayStart, newRayEnd, lastHitBlock);
                float blockReflectivity = SoundPhysics.getBlockReflectivity(lastHitBlock);
                float energyTowardsPlayer = 0.25f * (blockReflectivity * 0.75f + 0.25f);
                if (newRayHit.m_6662_() == HitResult.Type.MISS) {
                    totalRayDistance = (float)((double)totalRayDistance + lastHitPos.m_82554_(playerPos));
                    RaycastRenderer.addSoundBounceRay(newRayStart, newRayEnd, ChatFormatting.RED.m_126665_());
                } else {
                    Vec3 newRayHitPos = newRayHit.m_82450_();
                    RaycastRenderer.addSoundBounceRay(newRayStart, newRayHitPos, ChatFormatting.BLUE.m_126665_());
                    double newRayLength = lastHitPos.m_82554_(newRayHitPos);
                    int n = j;
                    bounceReflectivityRatio[n] = bounceReflectivityRatio[n] + blockReflectivity;
                    totalRayDistance = (float)((double)totalRayDistance + newRayLength);
                    lastHitPos = newRayHitPos;
                    lastHitNormal = new Vec3(newRayHit.m_82434_().m_253071_());
                    lastRayDir = newRayDir;
                    lastHitBlock = newRayHit.m_82425_();
                    Vec3 sharedAirspaceVector = SoundPhysics.getSharedAirspace(newRayHit, playerPos);
                    if (sharedAirspaceVector != null) {
                        audioDirection.addSharedAirspace(sharedAirspaceVector, totalRayDistance);
                    }
                }
                float reflectionDelay = (float)Math.max((double)totalRayDistance, 0.0) * 0.12f * blockReflectivity;
                float cross0 = 1.0f - Mth.m_14036_((float)Math.abs(reflectionDelay - 0.0f), (float)0.0f, (float)1.0f);
                float cross1 = 1.0f - Mth.m_14036_((float)Math.abs(reflectionDelay - 1.0f), (float)0.0f, (float)1.0f);
                float cross2 = 1.0f - Mth.m_14036_((float)Math.abs(reflectionDelay - 2.0f), (float)0.0f, (float)1.0f);
                float cross3 = Mth.m_14036_((float)(reflectionDelay - 2.0f), (float)0.0f, (float)1.0f);
                sendGain0 += cross0 * energyTowardsPlayer * 6.4f * rcpTotalRays;
                sendGain1 += cross1 * energyTowardsPlayer * 12.8f * rcpTotalRays;
                sendGain2 += cross2 * energyTowardsPlayer * 12.8f * rcpTotalRays;
                sendGain3 += cross3 * energyTowardsPlayer * 12.8f * rcpTotalRays;
                if (newRayHit.m_6662_() == HitResult.Type.MISS) continue block0;
            }
        }
        for (i = 0; i < bounceReflectivityRatio.length; ++i) {
            bounceReflectivityRatio[i] = bounceReflectivityRatio[i] / (float)numRays;
            Loggers.logEnvironment("Bounce reflectivity {}: {}", i, Float.valueOf(bounceReflectivityRatio[i]));
        }
        Vec3 newSoundPos = audioDirection.evaluateSoundPosition(soundPos, playerPos);
        if (newSoundPos != null) {
            SoundPhysics.setSoundPos(sourceID, newSoundPos);
        }
        float sharedAirspace = (float)audioDirection.getSharedAirspaces() * 64.0f * rcpTotalRays;
        Loggers.logEnvironment("Shared airspace: {} ({})", Float.valueOf(sharedAirspace), audioDirection.getSharedAirspaces());
        float sharedAirspaceWeight0 = Mth.m_14036_((float)(sharedAirspace / 20.0f), (float)0.0f, (float)1.0f);
        float sharedAirspaceWeight1 = Mth.m_14036_((float)(sharedAirspace / 15.0f), (float)0.0f, (float)1.0f);
        float sharedAirspaceWeight2 = Mth.m_14036_((float)(sharedAirspace / 10.0f), (float)0.0f, (float)1.0f);
        float sharedAirspaceWeight3 = Mth.m_14036_((float)(sharedAirspace / 10.0f), (float)0.0f, (float)1.0f);
        sendCutoff0 = (float)Math.exp(-occlusionAccumulation * (double)absorptionCoeff * 1.0) * (1.0f - sharedAirspaceWeight0) + sharedAirspaceWeight0;
        sendCutoff1 = (float)Math.exp(-occlusionAccumulation * (double)absorptionCoeff * 1.0) * (1.0f - sharedAirspaceWeight1) + sharedAirspaceWeight1;
        sendCutoff2 = (float)Math.exp(-occlusionAccumulation * (double)absorptionCoeff * 1.0) * (1.0f - sharedAirspaceWeight2) + sharedAirspaceWeight2;
        sendCutoff3 = (float)Math.exp(-occlusionAccumulation * (double)absorptionCoeff * 1.0) * (1.0f - sharedAirspaceWeight3) + sharedAirspaceWeight3;
        float averageSharedAirspace = (sharedAirspaceWeight0 + sharedAirspaceWeight1 + sharedAirspaceWeight2 + sharedAirspaceWeight3) * 0.25f;
        directCutoff = Math.max((float)Math.pow(averageSharedAirspace, 0.5) * 0.2f, directCutoff);
        directGain = auxOnly ? 0.0f : (float)Math.pow(directCutoff, 0.1);
        sendGain1 *= bounceReflectivityRatio[1];
        if (bounceReflectivityRatio.length > 2) {
            sendGain2 *= (float)Math.pow(bounceReflectivityRatio[2], 3.0);
        }
        if (bounceReflectivityRatio.length > 3) {
            sendGain3 *= (float)Math.pow(bounceReflectivityRatio[3], 4.0);
        }
        sendGain0 = Mth.m_14036_((float)sendGain0, (float)0.0f, (float)1.0f);
        sendGain1 = Mth.m_14036_((float)sendGain1, (float)0.0f, (float)1.0f);
        sendGain2 = Mth.m_14036_((float)(sendGain2 * 1.05f - 0.05f), (float)0.0f, (float)1.0f);
        sendGain3 = Mth.m_14036_((float)(sendGain3 * 1.05f - 0.05f), (float)0.0f, (float)1.0f);
        sendGain0 *= (float)Math.pow(sendCutoff0, 0.1);
        sendGain1 *= (float)Math.pow(sendCutoff1, 0.1);
        sendGain2 *= (float)Math.pow(sendCutoff2, 0.1);
        sendGain3 *= (float)Math.pow(sendCutoff3, 0.1);
        float soundDistance = (float)playerPos.m_82554_(soundPos);
        float maxSoundDistance = AL10.alGetSourcef((int)sourceID, (int)4131);
        float sendGainMultiplier = 1.0f - Math.min(soundDistance / (maxSoundDistance * SoundPhysicsMod.CONFIG.reverbDistance.get().floatValue()), 1.0f);
        sendGain0 = sendGainMultiplier * sendGain0;
        sendGain1 = sendGainMultiplier * sendGain1;
        sendGain2 = sendGainMultiplier * sendGain2;
        sendGain3 = sendGainMultiplier * sendGain3;
        Loggers.logEnvironment("Final environment settings: {}, {}, {}, {}", Float.valueOf(sendGain0), Float.valueOf(sendGain1), Float.valueOf(sendGain2), Float.valueOf(sendGain3));
        assert (SoundPhysics.minecraft.f_91074_ != null);
        if (SoundPhysics.minecraft.f_91074_.m_5842_()) {
            sendCutoff0 *= 0.4f;
            sendCutoff1 *= 0.4f;
            sendCutoff2 *= 0.4f;
            sendCutoff3 *= 0.4f;
        }
        SoundPhysics.setEnvironment(sourceID, sendGain0, sendGain1, sendGain2, sendGain3, sendCutoff0, sendCutoff1, sendCutoff2, sendCutoff3, directCutoff, directGain);
        return newSoundPos;
    }

    public static boolean isVoicechatSound(String sound) {
        return VOICECHAT_PATTERN.matcher(sound).matches();
    }

    public static boolean isAmbientSound(String sound) {
        return AMBIENT_PATTERN.matcher(sound).matches();
    }

    private static float getBlockReflectivity(BlockPos blockPos) {
        ClientLevelProxy levelProxy = SoundPhysics.getLevelProxy();
        if (levelProxy == null) {
            return SoundPhysicsMod.CONFIG.defaultBlockReflectivity.get().floatValue();
        }
        BlockState blockState = levelProxy.m_8055_(blockPos);
        return SoundPhysicsMod.REFLECTIVITY_CONFIG.getBlockDefinitionValue(blockState);
    }

    private static Vec3 reflect(Vec3 dir, Vec3 normal) {
        double dot = dir.m_82526_(normal) * 2.0;
        double x = dir.f_82479_ - dot * normal.f_82479_;
        double y = dir.f_82480_ - dot * normal.f_82480_;
        double z = dir.f_82481_ - dot * normal.f_82481_;
        return new Vec3(x, y, z);
    }

    private static double calculateOcclusion(Vec3 soundPos, Vec3 playerPos, SoundSource category, String sound) {
        if (SoundPhysicsMod.CONFIG.strictOcclusion.get().booleanValue()) {
            return Math.min(SoundPhysics.runOcclusion(soundPos, playerPos), (double)SoundPhysicsMod.CONFIG.maxOcclusion.get().floatValue());
        }
        boolean isBlock = category == SoundSource.BLOCKS || BLOCK_PATTERN.matcher(sound).matches();
        double variationFactor = SoundPhysicsMod.CONFIG.occlusionVariation.get().floatValue();
        if (isBlock) {
            variationFactor = Math.max(variationFactor, 0.501);
        }
        double occlusionAccMin = Double.MAX_VALUE;
        occlusionAccMin = Math.min(occlusionAccMin, SoundPhysics.runOcclusion(soundPos, playerPos));
        if (variationFactor > 0.0) {
            for (int x = -1; x <= 1; x += 2) {
                for (int y = -1; y <= 1; y += 2) {
                    for (int z = -1; z <= 1; z += 2) {
                        Vec3 offset = new Vec3((double)x, (double)y, (double)z).m_82490_(variationFactor);
                        occlusionAccMin = Math.min(occlusionAccMin, SoundPhysics.runOcclusion(soundPos.m_82549_(offset), playerPos.m_82549_(offset)));
                    }
                }
            }
        }
        return Math.min(occlusionAccMin, (double)SoundPhysicsMod.CONFIG.maxOcclusion.get().floatValue());
    }

    private static double runOcclusion(Vec3 soundPos, Vec3 playerPos) {
        ClientLevelProxy levelProxy = SoundPhysics.getLevelProxy();
        if (levelProxy == null) {
            return 0.0;
        }
        double occlusionAccumulation = 0.0;
        Vec3 rayOrigin = soundPos;
        BlockPos lastBlockPos = new BlockPos((int)soundPos.f_82479_, (int)soundPos.f_82480_, (int)soundPos.f_82481_);
        for (int i = 0; i < SoundPhysicsMod.CONFIG.maxOcclusionRays.get(); ++i) {
            BlockHitResult rayHit = RaycastUtils.rayCast(SoundPhysics.getLevelProxy(), rayOrigin, playerPos, lastBlockPos);
            lastBlockPos = rayHit.m_82425_();
            if (rayHit.m_6662_() == HitResult.Type.MISS) {
                RaycastRenderer.addOcclusionRay(rayOrigin, playerPos.m_82520_(0.0, -0.1, 0.0), Mth.m_14169_((float)(0.33333334f * (1.0f - Math.min(1.0f, (float)occlusionAccumulation / 12.0f))), (float)1.0f, (float)1.0f));
                break;
            }
            RaycastRenderer.addOcclusionRay(rayOrigin, rayHit.m_82450_(), Mth.m_14169_((float)(0.33333334f * (1.0f - Math.min(1.0f, (float)occlusionAccumulation / 12.0f))), (float)1.0f, (float)1.0f));
            BlockPos blockHitPos = rayHit.m_82425_();
            rayOrigin = rayHit.m_82450_();
            BlockState blockHit = levelProxy.m_8055_(blockHitPos);
            float blockOcclusion = SoundPhysicsMod.OCCLUSION_CONFIG.getBlockDefinitionValue(blockHit);
            Vec3 dirVec = rayOrigin.m_82492_((double)blockHitPos.m_123341_() + 0.5, (double)blockHitPos.m_123342_() + 0.5, (double)blockHitPos.m_123343_() + 0.5);
            Direction sideHit = Direction.m_122366_((double)dirVec.f_82479_, (double)dirVec.f_82480_, (double)dirVec.f_82481_);
            if (!blockHit.m_60783_((BlockGetter)levelProxy, rayHit.m_82425_(), sideHit)) {
                blockOcclusion *= SoundPhysicsMod.CONFIG.nonFullBlockOcclusionFactor.get().floatValue();
            }
            Loggers.logOcclusion("{} \t{},{},{}", blockHit.m_60734_().m_7705_(), rayOrigin.f_82479_, rayOrigin.f_82480_, rayOrigin.f_82481_);
            occlusionAccumulation += (double)blockOcclusion;
            if (!(occlusionAccumulation > (double)SoundPhysicsMod.CONFIG.maxOcclusion.get().floatValue())) continue;
            Loggers.logOcclusion("Max occlusion reached after {} steps", i + 1);
            break;
        }
        return occlusionAccumulation;
    }

    private static ClientLevelProxy getLevelProxy() {
        return LevelAccessUtils.getClientLevelProxy(minecraft);
    }

    @Nullable
    private static Vec3 getSharedAirspace(BlockHitResult hit, Vec3 listenerPosition) {
        Vector3f hitNormal = hit.m_82434_().m_253071_();
        Vec3 rayStart = new Vec3(hit.m_82450_().f_82479_ + (double)hitNormal.x() * 0.001, hit.m_82450_().f_82480_ + (double)hitNormal.y() * 0.001, hit.m_82450_().f_82481_ + (double)hitNormal.z() * 0.001);
        return SoundPhysics.getSharedAirspace(rayStart, listenerPosition);
    }

    @Nullable
    private static Vec3 getSharedAirspace(Vec3 soundPosition, Vec3 listenerPosition) {
        BlockHitResult finalRayHit = RaycastUtils.rayCast(SoundPhysics.getLevelProxy(), soundPosition, listenerPosition, null);
        if (finalRayHit.m_6662_() == HitResult.Type.MISS) {
            RaycastRenderer.addSoundBounceRay(soundPosition, listenerPosition.m_82520_(0.0, -0.1, 0.0), ChatFormatting.WHITE.m_126665_());
            return soundPosition.m_82546_(listenerPosition);
        }
        return null;
    }

    public static void setDefaultEnvironment(int sourceID) {
        SoundPhysics.setDefaultEnvironment(sourceID, false);
    }

    public static void setDefaultEnvironment(int sourceID, boolean auxOnly) {
        SoundPhysics.setEnvironment(sourceID, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, auxOnly ? 0.0f : 1.0f);
    }

    public static void setEnvironment(int sourceID, float sendGain0, float sendGain1, float sendGain2, float sendGain3, float sendCutoff0, float sendCutoff1, float sendCutoff2, float sendCutoff3, float directCutoff, float directGain) {
        if (!SoundPhysicsMod.CONFIG.enabled.get().booleanValue()) {
            return;
        }
        if (maxAuxSends >= 4) {
            EXTEfx.alFilterf((int)sendFilter0, (int)1, (float)sendGain0);
            EXTEfx.alFilterf((int)sendFilter0, (int)2, (float)sendCutoff0);
            AL11.alSource3i((int)sourceID, (int)131078, (int)auxFXSlot0, (int)3, (int)sendFilter0);
            Loggers.logALError("Set environment filter0:");
        }
        if (maxAuxSends >= 3) {
            EXTEfx.alFilterf((int)sendFilter1, (int)1, (float)sendGain1);
            EXTEfx.alFilterf((int)sendFilter1, (int)2, (float)sendCutoff1);
            AL11.alSource3i((int)sourceID, (int)131078, (int)auxFXSlot1, (int)2, (int)sendFilter1);
            Loggers.logALError("Set environment filter1:");
        }
        if (maxAuxSends >= 2) {
            EXTEfx.alFilterf((int)sendFilter2, (int)1, (float)sendGain2);
            EXTEfx.alFilterf((int)sendFilter2, (int)2, (float)sendCutoff2);
            AL11.alSource3i((int)sourceID, (int)131078, (int)auxFXSlot2, (int)1, (int)sendFilter2);
            Loggers.logALError("Set environment filter2:");
        }
        if (maxAuxSends >= 1) {
            EXTEfx.alFilterf((int)sendFilter3, (int)1, (float)sendGain3);
            EXTEfx.alFilterf((int)sendFilter3, (int)2, (float)sendCutoff3);
            AL11.alSource3i((int)sourceID, (int)131078, (int)auxFXSlot3, (int)0, (int)sendFilter3);
            Loggers.logALError("Set environment filter3:");
        }
        EXTEfx.alFilterf((int)directFilter0, (int)1, (float)directGain);
        EXTEfx.alFilterf((int)directFilter0, (int)2, (float)directCutoff);
        AL11.alSourcei((int)sourceID, (int)131077, (int)directFilter0);
        Loggers.logALError("Set environment directFilter0:");
        AL11.alSourcef((int)sourceID, (int)131079, (float)SoundPhysicsMod.CONFIG.airAbsorption.get().floatValue());
        Loggers.logALError("Set environment airAbsorption:");
    }

    private static void setSoundPos(int sourceID, Vec3 pos) {
        AL11.alSource3f((int)sourceID, (int)4100, (float)((float)pos.f_82479_), (float)((float)pos.f_82480_), (float)((float)pos.f_82481_));
    }

    protected static void setReverbParams(ReverbParams r, int auxFXSlot, int reverbSlot) {
        EXTEfx.alEffectf((int)reverbSlot, (int)1, (float)r.density);
        Loggers.logALError("Error while assigning reverb density: " + r.density);
        EXTEfx.alEffectf((int)reverbSlot, (int)2, (float)r.diffusion);
        Loggers.logALError("Error while assigning reverb diffusion: " + r.diffusion);
        EXTEfx.alEffectf((int)reverbSlot, (int)3, (float)r.gain);
        Loggers.logALError("Error while assigning reverb gain: " + r.gain);
        EXTEfx.alEffectf((int)reverbSlot, (int)4, (float)r.gainHF);
        Loggers.logALError("Error while assigning reverb gainHF: " + r.gainHF);
        EXTEfx.alEffectf((int)reverbSlot, (int)6, (float)r.decayTime);
        Loggers.logALError("Error while assigning reverb decayTime: " + r.decayTime);
        EXTEfx.alEffectf((int)reverbSlot, (int)7, (float)r.decayHFRatio);
        Loggers.logALError("Error while assigning reverb decayHFRatio: " + r.decayHFRatio);
        EXTEfx.alEffectf((int)reverbSlot, (int)9, (float)r.reflectionsGain);
        Loggers.logALError("Error while assigning reverb reflectionsGain: " + r.reflectionsGain);
        EXTEfx.alEffectf((int)reverbSlot, (int)12, (float)r.lateReverbGain);
        Loggers.logALError("Error while assigning reverb lateReverbGain: " + r.lateReverbGain);
        EXTEfx.alEffectf((int)reverbSlot, (int)13, (float)r.lateReverbDelay);
        Loggers.logALError("Error while assigning reverb lateReverbDelay: " + r.lateReverbDelay);
        EXTEfx.alEffectf((int)reverbSlot, (int)19, (float)r.airAbsorptionGainHF);
        Loggers.logALError("Error while assigning reverb airAbsorptionGainHF: " + r.airAbsorptionGainHF);
        EXTEfx.alEffectf((int)reverbSlot, (int)22, (float)r.roomRolloffFactor);
        Loggers.logALError("Error while assigning reverb roomRolloffFactor: " + r.roomRolloffFactor);
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot, (int)1, (int)reverbSlot);
    }
}

