/*
 * Decompiled with CFR 0.152.
 */
package mezz.itemzoom.client;

import com.mojang.blaze3d.platform.InputConstants;
import mezz.itemzoom.client.KeyBindings;
import mezz.itemzoom.client.config.Config;

public class InputHandler {
    private final Config config;
    private boolean enableKeyHeld = false;

    public InputHandler(Config config) {
        this.config = config;
    }

    public boolean handleInput(InputConstants.Key input) {
        KeyBindings keyBindings = KeyBindings.getInstance();
        if (keyBindings.toggle.isActiveAndMatches(input)) {
            this.config.toggleEnabled();
            return true;
        }
        if (keyBindings.zoomIn.isActiveAndMatches(input)) {
            this.config.increaseZoom();
            return true;
        }
        if (keyBindings.zoomOut.isActiveAndMatches(input)) {
            this.config.decreaseZoom();
            return true;
        }
        if (keyBindings.hold.isActiveAndMatches(input)) {
            this.enableKeyHeld = true;
            return true;
        }
        return false;
    }

    public boolean handleInputReleased(InputConstants.Key input) {
        KeyBindings keyBindings = KeyBindings.getInstance();
        if (keyBindings.hold.isActiveAndMatches(input)) {
            this.enableKeyHeld = false;
            return true;
        }
        return false;
    }

    public boolean isEnableKeyHeld() {
        return this.enableKeyHeld;
    }
}

