/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.client.screen.BargainScreen;
import tictim.paraglider.network.Kind;
import tictim.paraglider.network.SyncMovementHandle;
import tictim.paraglider.network.message.BargainDialogMsg;
import tictim.paraglider.network.message.BargainEndMsg;
import tictim.paraglider.network.message.BargainInitMsg;
import tictim.paraglider.network.message.Msg;
import tictim.paraglider.network.message.SyncCatalogMsg;
import tictim.paraglider.network.message.SyncLookAtMsg;
import tictim.paraglider.network.message.SyncMovementMsg;
import tictim.paraglider.network.message.SyncPlayerStateMapMsg;
import tictim.paraglider.network.message.SyncRemoteMovementMsg;
import tictim.paraglider.network.message.SyncVesselMsg;
import tictim.paraglider.network.message.SyncWindMsg;
import tictim.paraglider.wind.Wind;

public final class ClientPacketHandler {
    private ClientPacketHandler() {
    }

    public static void handleSyncPlayerStateMap(SyncPlayerStateMapMsg msg) {
        ClientPacketHandler.trace(Kind.MOVEMENT, msg);
        ParagliderMod.instance().setSyncedPlayerStateMap(msg.stateMap());
    }

    public static void handleSyncMovement(SyncMovementMsg msg) {
        ClientPacketHandler.trace(Kind.MOVEMENT, msg);
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        Movement movement = Movement.get((Player)mc.f_91074_);
        if (movement instanceof SyncMovementHandle) {
            SyncMovementHandle smh = (SyncMovementHandle)((Object)movement);
            smh.syncMovement(msg.state(), msg.stamina(), msg.depleted(), msg.recoveryDelay());
        }
    }

    public static void handleSyncRemoteMovement(SyncRemoteMovementMsg msg) {
        ClientPacketHandler.trace(Kind.MOVEMENT, msg);
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Player player = mc.f_91073_.m_46003_(msg.entityId());
        if (player == null) {
            return;
        }
        Movement movement = Movement.get(player);
        if (movement instanceof SyncMovementHandle) {
            SyncMovementHandle smh = (SyncMovementHandle)((Object)movement);
            smh.syncRemoteMovement(msg.state());
        }
    }

    public static void handleSyncVessel(SyncVesselMsg msg) {
        ClientPacketHandler.trace(Kind.VESSEL, msg);
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        VesselContainer vessels = VesselContainer.get((Player)mc.f_91074_);
        vessels.setHeartContainer(msg.heartContainers(), false, false);
        vessels.setStaminaVessel(msg.staminaVessels(), false, false);
        Stamina.get((Player)mc.f_91074_).setStamina(msg.stamina());
    }

    public static void handleBargainInit(BargainInitMsg msg) {
        ClientPacketHandler.trace(Kind.BARGAIN, msg);
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new BargainScreen(msg.sessionId(), msg.catalog(), msg.lookAt(), msg.dialog()));
    }

    public static void handleSyncCatalog(SyncCatalogMsg msg) {
        ClientPacketHandler.trace(Kind.BARGAIN, msg);
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof BargainScreen) {
            BargainScreen bargainScreen = (BargainScreen)screen;
            if (bargainScreen.sessionId == msg.sessionId()) {
                bargainScreen.setCatalog(msg.catalog());
            }
        }
    }

    public static void handleSyncLookAt(SyncLookAtMsg msg) {
        ClientPacketHandler.trace(Kind.BARGAIN, msg);
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof BargainScreen) {
            BargainScreen bargainScreen = (BargainScreen)screen;
            if (bargainScreen.sessionId == msg.sessionId()) {
                bargainScreen.setLookAt(msg.lookAt());
            }
        }
    }

    public static void handleBargainDialog(BargainDialogMsg msg) {
        ClientPacketHandler.trace(Kind.BARGAIN, msg);
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof BargainScreen) {
            BargainScreen bargainScreen = (BargainScreen)screen;
            if (bargainScreen.sessionId == msg.sessionId()) {
                bargainScreen.setDialog(msg.dialog());
            }
        }
    }

    public static void handleBargainEnd(BargainEndMsg msg) {
        ClientPacketHandler.trace(Kind.BARGAIN, msg);
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof BargainScreen) {
            BargainScreen bargainScreen = (BargainScreen)screen;
            if (bargainScreen.sessionId == msg.sessionId()) {
                mc.m_91152_(null);
            }
        }
    }

    public static void handleSyncWind(SyncWindMsg msg) {
        ClientPacketHandler.trace(Kind.WIND, msg);
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        Wind wind = Wind.of((LevelAccessor)world);
        if (wind != null) {
            wind.put(msg.windChunk());
        }
    }

    private static void trace(@NotNull Kind kind, @NotNull Msg msg) {
        if (kind.isTraceEnabled()) {
            ParagliderMod.LOGGER.debug("Received {} from server", (Object)msg);
        }
    }
}

