/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.bargain;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.bargain.Bargain;
import tictim.paraglider.api.bargain.BargainType;
import tictim.paraglider.bargain.BargainContext;
import tictim.paraglider.contents.BargainTypeRegistry;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.network.ParagliderNetwork;

public final class BargainHandler {
    private static final Map<ServerPlayer, BargainContext> bargains = new Object2ObjectOpenHashMap();
    private static int bargainSessionIncr;

    private BargainHandler() {
    }

    public static boolean initiate(@NotNull Player player, @NotNull ResourceLocation bargainType, @Nullable BlockPos pos, @Nullable ResourceLocation advancement, @Nullable Vec3 lookAt) {
        BargainContext ctx;
        BargainContext prevCtx;
        Objects.requireNonNull(player, "player == null");
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BargainType type = BargainTypeRegistry.get().getFromID(serverPlayer.m_284548_(), Objects.requireNonNull(bargainType, "bargainType == null"));
        if (type == null) {
            return false;
        }
        Object2ObjectOpenHashMap bargains = player.m_9236_().m_7465_().m_44013_(Contents.get().bargainRecipeType()).stream().filter(b -> bargainType.equals((Object)b.getBargainType()) && b.isAvailableFor(player, pos)).collect(Collectors.toMap(Recipe::m_6423_, b -> b, (b1, b2) -> b1, Object2ObjectOpenHashMap::new));
        if (bargains.isEmpty()) {
            return false;
        }
        if ((prevCtx = BargainHandler.bargains.put(serverPlayer, ctx = new BargainContext(serverPlayer, bargainSessionIncr++, type, bargainType, (Map<ResourceLocation, Bargain>)bargains, advancement, lookAt))) != null) {
            prevCtx.markFinished();
        }
        ParagliderNetwork.get().initBargain(ctx, type.dialog().randomInitialDialog(ParagliderUtils.DIALOG_RNG));
        return true;
    }

    @NotNull
    public static @NotNull @Unmodifiable Map<@NotNull ServerPlayer, @NotNull BargainContext> bargains() {
        return Collections.unmodifiableMap(bargains);
    }

    @Nullable
    public static BargainContext getBargain(@NotNull ServerPlayer player) {
        return bargains.get(player);
    }

    @ApiStatus.Internal
    public static void update() {
        Iterator<BargainContext> it = bargains.values().iterator();
        while (it.hasNext()) {
            BargainContext ctx = it.next();
            if (ctx.isFinished()) {
                it.remove();
                ParagliderNetwork.get().bargainEndToClient(ctx);
                continue;
            }
            ctx.checkForUpdates();
            if (!ctx.isFinished()) continue;
            it.remove();
            ParagliderNetwork.get().bargainEndToClient(ctx);
        }
    }
}

