/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import com.mojang.math.Axis;
import immersive_aircraft.Items;
import immersive_aircraft.Main;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirshipEntity;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapons.HeavyCrossbow;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.util.InterpolatedFloat;
import immersive_aircraft.util.Utils;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class WarshipEntity
extends AirshipEntity {
    private final HeavyCrossbow turret;
    public final InterpolatedFloat turretYaw = new InterpolatedFloat(5.0f);
    public final InterpolatedFloat turretPitch = new InterpolatedFloat(5.0f);
    private final List<Trail> trails = List.of(new Trail(15, 0.25f), new Trail(15, 0.25f), new Trail(11, 0.25f), new Trail(11, 0.25f));

    public WarshipEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world);
        this.turret = new HeavyCrossbow(this, new ItemStack((ItemLike)Items.HEAVY_CROSSBOW.get()), new WeaponMount(new Matrix4f(), false), -1, 5.0f, 0.0f);
    }

    @Override
    public Item asItem() {
        return Items.WARSHIP.get();
    }

    @Override
    public List<Trail> getTrails() {
        return this.trails;
    }

    @Override
    protected void addTrails(Matrix4f transform) {
        Matrix4f tr = new Matrix4f((Matrix4fc)transform);
        tr.translate((Vector3fc)new Vector3f(0.0f, 1.4f, -2.75f));
        tr.rotate((Quaternionfc)Axis.f_252403_.m_252977_(this.engineRotation.getSmooth() * 40.0f));
        this.trail(tr, 0, 0.2f);
        tr = new Matrix4f((Matrix4fc)transform);
        tr.translate((Vector3fc)new Vector3f(2.5f, 4.5f, -5.5f));
        tr.rotate((Quaternionfc)Axis.f_252403_.m_252977_(this.engineRotation.getSmooth() * 40.0f));
        this.trail(tr, 1, 0.2f);
        tr = new Matrix4f((Matrix4fc)transform);
        tr.translate((Vector3fc)new Vector3f(0.0f, 4.5f, -5.5f));
        tr.rotate((Quaternionfc)Axis.f_252403_.m_252977_(this.engineRotation.getSmooth() * 40.0f));
        this.trail(tr, 2, 0.25f);
        tr = new Matrix4f((Matrix4fc)transform);
        tr.translate((Vector3fc)new Vector3f(-2.5f, 4.5f, -5.5f));
        tr.rotate((Quaternionfc)Axis.f_252403_.m_252977_(this.engineRotation.getSmooth() * 40.0f));
        this.trail(tr, 3, 0.2f);
    }

    @Override
    public void setAnimationVariables(float tickDelta) {
        super.setAnimationVariables(tickDelta);
        BBAnimationVariables.set("turret_yaw", -this.turretYaw.getSmooth(tickDelta));
        BBAnimationVariables.set("turret_pitch", -this.turretPitch.getSmooth(tickDelta));
        if (this.weapons.isEmpty()) {
            BBAnimationVariables.set("balloon_roll", (float)Utils.cosNoise(((float)this.f_19797_ + tickDelta) * 0.01f) * 0.2f + this.getRoll(tickDelta) * 0.5f);
            BBAnimationVariables.set("balloon_pitch", (float)Utils.cosNoise(77.0f + ((float)this.f_19797_ + tickDelta) * 0.02f) * 0.2f);
        } else {
            BBAnimationVariables.set("balloon_roll", 0.0f);
            BBAnimationVariables.set("balloon_pitch", 0.0f);
        }
        BBAnimationVariables.set("chest", (float)Math.max((double)0.0, (double)this.getSpeedVector().f_82480_));
        BBAnimationVariables.set("turret_cooldown", this.turret.getCooldown());
    }

    @Override
    protected float getEngineReactionSpeed() {
        return 100.0f;
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.WARSHIP.get();
    }

    @Override
    protected SoundEvent getEngineStartSound() {
        return Sounds.ENGINE_START_WARSHIP.get();
    }

    public Vector3f boneOffset(Vector3f position, Vector3f rotation, Vector3f origin) {
        position.sub((Vector3fc)origin);
        position = Utils.fromXYZ(rotation).transform(position);
        position.add((Vector3fc)origin);
        return position;
    }

    public Entity getTurretGunner() {
        List passengers = this.m_20197_();
        if (passengers.size() >= 2) {
            return (Entity)passengers.get(1);
        }
        return null;
    }

    public boolean isTurretGunner(Entity entity) {
        return this.getTurretGunner() == entity;
    }

    @Override
    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction positionUpdater) {
        Matrix4f transform = this.getVehicleTransform();
        if (this.isTurretGunner(passenger)) {
            Vector3f position = this.getGunnerPosition();
            float x = position.x();
            float y = position.y();
            float z = position.z();
            Vector4f worldPosition = this.transformPosition(transform, x, y += (float)passenger.m_6049_(), z);
            positionUpdater.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            this.copyEntityData(passenger);
        } else {
            super.m_19956_(passenger, positionUpdater);
        }
    }

    private Vector3f getGunnerPosition() {
        float pitch = this.turretPitch.getSmooth(1.0f) / 180.0f * (float)java.lang.Math.PI;
        float yaw = this.turretYaw.getSmooth(1.0f) / 180.0f * (float)java.lang.Math.PI;
        Vector3f position = new Vector3f(0.0f, 0.5f, 2.5f);
        this.boneOffset(position, new Vector3f(0.0f, -yaw, 0.0f), new Vector3f(0.0f, 0.5f, 2.0f));
        this.boneOffset(position, new Vector3f(pitch, 0.0f, 0.0f), new Vector3f(0.0f, 0.5f, 0.9f));
        return position;
    }

    @Override
    public void copyEntityData(Entity entity) {
        if (this.isTurretGunner(entity)) {
            entity.m_5618_(this.m_146908_() + this.turretYaw.getSmooth(1.0f));
            float py = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float cpy = Mth.m_14036_((float)py, (float)-45.0f, (float)45.0f);
            entity.f_19859_ += cpy - py;
            entity.m_146922_(entity.m_146908_() + cpy - py);
            entity.m_5616_(entity.m_146908_());
            float pp = Mth.m_14177_((float)(entity.m_146909_() - this.m_146909_()));
            float cpp = Mth.m_14036_((float)pp, (float)-30.0f, (float)30.0f);
            entity.f_19860_ += cpp - pp;
            entity.m_146926_(entity.m_146909_() + cpp - pp);
        } else {
            super.copyEntityData(entity);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.turret.tick();
        Entity gunner = this.getTurretGunner();
        if (gunner != null) {
            this.turretYaw.update(Math.clamp((float)-75.0f, (float)75.0f, (float)Mth.m_14177_((float)(gunner.m_6080_() - this.m_146908_()))));
            this.turretPitch.update(Math.clamp((float)-30.0f, (float)30.0f, (float)gunner.m_146909_()));
        } else {
            this.turretYaw.update(0.0f);
            this.turretPitch.update(0.0f);
        }
        Vector3f gunnerPosition = this.getGunnerPosition();
        Quaternionf turretRot = Utils.fromXYZ(Math.toRadians((float)this.turretPitch.get(1.0f)), Math.toRadians((float)(-this.turretYaw.get(1.0f))), 0.0f);
        this.turret.getMount().transform().identity().translate((Vector3fc)gunnerPosition).rotate((Quaternionfc)turretRot);
    }

    @Override
    public void clientFireWeapons(Entity entity) {
        if (this.isTurretGunner(entity)) {
            this.turret.clientFire(-1);
        } else {
            super.clientFireWeapons(entity);
        }
    }

    @Override
    public void fireWeapon(int slot, int index, Vector3f direction) {
        if (slot == -1) {
            this.turret.fire(direction);
        } else {
            super.fireWeapon(slot, index, direction);
        }
    }

    @Override
    public double getZoom() {
        return 5.0f + this.enginePower.getSmooth(Main.frameTime) * 5.0f;
    }
}

