/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.network;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.core.CommonAbstractions;
import fuzs.forgeconfigscreens.core.NetworkingHelper;
import fuzs.forgeconfigscreens.network.S2CGrantPermissionsMessage;
import fuzs.forgeconfigscreens.network.S2CUpdateConfigMessage;
import fuzs.forgeconfigscreens.network.client.C2SAskPermissionsMessage;
import fuzs.forgeconfigscreens.network.client.C2SSendConfigMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public final class ServerMessageHandles {
    private ServerMessageHandles() {
    }

    public static void handleAskPermissions(C2SAskPermissionsMessage message, MinecraftServer server, ServerGamePacketListenerImpl handler, ServerPlayer player, ServerLevel level) {
        if (player.m_20310_(server.m_7022_())) {
            NetworkingHelper.sendTo(player, new S2CGrantPermissionsMessage());
        }
    }

    public static void handleSendConfig(C2SSendConfigMessage packet, MinecraftServer server, ServerGamePacketListenerImpl handler, ServerPlayer player, ServerLevel level) {
        if (server.m_6982_() && player.m_20310_(server.m_7022_())) {
            ModConfig config = (ModConfig)ConfigTracker.INSTANCE.fileMap().get(packet.fileName());
            if (config != null) {
                CommentedConfig receivedConfig = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(packet.fileData()));
                config.getConfigData().putAll((UnmodifiableConfig)receivedConfig);
                config.save();
                config.getSpec().afterReload();
                CommonAbstractions.INSTANCE.fireReloadingEvent(config);
                NetworkingHelper.sendToAllExcept(server, player, new S2CUpdateConfigMessage(packet.fileName(), packet.fileData()));
                ForgeConfigScreens.LOGGER.info("Server config has been updated by {}", (Object)player.m_5446_().getString());
            } else {
                ForgeConfigScreens.LOGGER.error("Failed to update server config with data received from {}", (Object)player.m_5446_().getString());
            }
        }
    }
}

