/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.core;

import fuzs.forgeconfigscreens.core.CommonAbstractions;
import fuzs.forgeconfigscreens.core.WritableMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class NetworkingHelper {
    private static Packet<?> toClientboundPacket(WritableMessage message) {
        return CommonAbstractions.INSTANCE.toClientboundPacket(message);
    }

    private static Packet<?> toServerboundPacket(WritableMessage message) {
        return CommonAbstractions.INSTANCE.toServerboundPacket(message);
    }

    public static void sendToServer(Connection connection, WritableMessage message) {
        connection.m_129512_(NetworkingHelper.toServerboundPacket(message));
    }

    public static void sendTo(ServerPlayer player, WritableMessage message) {
        player.f_8906_.m_9829_(NetworkingHelper.toClientboundPacket(message));
    }

    public static void sendToAll(MinecraftServer server, WritableMessage message) {
        server.m_6846_().m_11268_(NetworkingHelper.toClientboundPacket(message));
    }

    public static void sendToAllExcept(MinecraftServer server, ServerPlayer exclude, WritableMessage message) {
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            if (player == exclude) continue;
            NetworkingHelper.sendTo(player, message);
        }
    }

    public static void sendToAllNear(MinecraftServer server, BlockPos pos, Level level, WritableMessage message) {
        NetworkingHelper.sendToAllNearExcept(server, null, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 64.0, level, message);
    }

    public static void sendToAllNear(MinecraftServer server, double posX, double posY, double posZ, double distance, Level level, WritableMessage message) {
        NetworkingHelper.sendToAllNearExcept(server, null, posX, posY, posZ, 64.0, level, message);
    }

    public static void sendToAllNearExcept(MinecraftServer server, @Nullable ServerPlayer exclude, double posX, double posY, double posZ, double distance, Level level, WritableMessage message) {
        server.m_6846_().m_11241_((Player)exclude, posX, posY, posZ, distance, level.m_46472_(), NetworkingHelper.toClientboundPacket(message));
    }

    public static void sendToAllTracking(Entity entity, WritableMessage message) {
        ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8445_(entity, NetworkingHelper.toClientboundPacket(message));
    }

    public static void sendToAllTrackingAndSelf(Entity entity, WritableMessage message) {
        ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8394_(entity, NetworkingHelper.toClientboundPacket(message));
    }

    public static void sendToDimension(MinecraftServer server, Level level, WritableMessage message) {
        NetworkingHelper.sendToDimension(server, (ResourceKey<Level>)level.m_46472_(), message);
    }

    public static void sendToDimension(MinecraftServer server, ResourceKey<Level> dimension, WritableMessage message) {
        server.m_6846_().m_11270_(NetworkingHelper.toClientboundPacket(message), dimension);
    }

    @FunctionalInterface
    public static interface ServerMessageListener<T> {
        public void handle(T var1, MinecraftServer var2, ServerGamePacketListenerImpl var3, ServerPlayer var4, ServerLevel var5);
    }

    public static interface ClientMessageListener<T> {
        public void handle(T var1, Minecraft var2, ClientPacketListener var3, LocalPlayer var4, ClientLevel var5);
    }
}

