/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.platform;

import com.mojang.blaze3d.platform.NativeImage;
import com.mrcrayfish.catalogue.client.ForgeModData;
import com.mrcrayfish.catalogue.client.IModData;
import com.mrcrayfish.catalogue.platform.services.IPlatformHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.resource.ResourcePackLoader;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public boolean isForge() {
        return true;
    }

    @Override
    public List<IModData> getAllModData() {
        return ModList.get().getMods().stream().map(ForgeModData::new).collect(Collectors.toList());
    }

    @Override
    public File getModDirectory() {
        return FMLPaths.MODSDIR.get().toFile();
    }

    @Override
    public void loadNativeImage(String modId, String resource, Consumer<NativeImage> consumer) {
        ResourcePackLoader.getPackFor((String)modId).ifPresent(resources -> {
            IoSupplier supplier = resources.m_8017_(new String[]{resource});
            if (supplier != null) {
                try (InputStream is = (InputStream)supplier.m_247737_();
                     NativeImage image = NativeImage.m_85058_((InputStream)is);){
                    consumer.accept(image);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }
}

