/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public class FluidRenderUtil {
    public static void renderTiledFluid(GuiGraphics graphics, int x, int y, int sizeX, int sizeY, FluidStack fluid, boolean hasColor) {
        TextureAtlasSprite fluidSprite = FluidRenderUtil.fluidSprite(fluid, hasColor);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)fluidSprite.m_247685_());
        graphics.m_280159_(x, y, 0, sizeX, sizeY, fluidSprite);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static TextureAtlasSprite fluidSprite(FluidStack fluid, boolean hasColor) {
        TextureAtlasSprite fluidSprite = FluidStackHooks.getStillTexture((FluidStack)fluid);
        if (hasColor) {
            int color = FluidStackHooks.getColor((FluidStack)fluid);
            float a = (float)((color & 0xFF000000) >> 24) / 255.0f;
            a = a <= 0.001f ? 1.0f : a;
            float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((color & 0xFF00) >> 8) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        }
        return fluidSprite;
    }
}

