/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.inventory.AbstractInventoryMenu;
import wily.betterfurnaces.network.Messages;
import wily.betterfurnaces.network.PacketSyncEnergy;
import wily.betterfurnaces.network.PacketSyncFluid;
import wily.factoryapi.base.Storages;

public class SmeltingMenu
extends AbstractInventoryMenu<SmeltingBlockEntity> {
    public SmeltingMenu(MenuType<?> containerType, int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player) {
        this(containerType, windowId, world, pos, playerInventory, player, (ContainerData)new SimpleContainerData(5));
    }

    public SmeltingMenu(int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player) {
        this((MenuType)ModObjects.FURNACE_CONTAINER.get(), windowId, world, pos, playerInventory, player, (ContainerData)new SimpleContainerData(5));
    }

    public SmeltingMenu(MenuType<?> containerType, int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player, ContainerData fields) {
        super(containerType, windowId, world, pos, playerInventory, player, fields);
        SmeltingMenu.m_38886_((ContainerData)this.fields, (int)5);
    }

    public boolean showInventoryButtons() {
        return this.fields.m_6413_(4) == 1;
    }

    public int getRedstoneMode() {
        return ((SmeltingBlockEntity)this.be).getRedstoneSetting();
    }

    public int getComSub() {
        return ((SmeltingBlockEntity)this.be).getRedstoneComSub();
    }

    public boolean getAutoInput() {
        return ((SmeltingBlockEntity)this.be).getAutoInput() == 1;
    }

    public boolean getAutoOutput() {
        return ((SmeltingBlockEntity)this.be).getAutoOutput() == 1;
    }

    @Override
    public BlockPos getPos() {
        return ((SmeltingBlockEntity)this.be).m_58899_();
    }

    public int getCookScaled(int pixels) {
        int i = this.fields.m_6413_(2);
        int j = this.fields.m_6413_(3);
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getBurnLeftScaled(int pixels) {
        int i = this.fields.m_6413_(1);
        if (i == 0) {
            i = 200;
        }
        return this.fields.m_6413_(0) * pixels / i;
    }

    public int getEnergyStored() {
        return ((SmeltingBlockEntity)this.be).energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return ((SmeltingBlockEntity)this.be).energyStorage.getMaxEnergyStored();
    }

    public int BurnTimeGet() {
        return this.fields.m_6413_(0);
    }

    @Override
    protected void updateChanges() {
        super.updateChanges();
        Direction[] directionArray = this.player;
        if (directionArray instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)directionArray;
            for (Direction d : Direction.values()) {
                ((SmeltingBlockEntity)this.be).getStorage(Storages.FLUID, d).ifPresent(t -> Messages.INSTANCE.sendToPlayer(sp, (Object)new PacketSyncFluid(((SmeltingBlockEntity)this.be).m_58899_(), d, t.getFluidStack())));
            }
            Messages.INSTANCE.sendToPlayer(sp, (Object)new PacketSyncEnergy(((SmeltingBlockEntity)this.be).m_58899_(), ((SmeltingBlockEntity)this.be).energyStorage.getEnergyStored()));
        }
    }

    @Override
    public boolean m_6875_(Player playerIn) {
        return SmeltingMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)((SmeltingBlockEntity)this.be).m_58904_(), (BlockPos)((SmeltingBlockEntity)this.be).m_58899_()), (Player)this.player, (Block)((SmeltingBlockEntity)this.be).m_58900_().m_60734_());
    }
}

