/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.client;

import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import wily.betterfurnaces.BetterFurnacesReforged;
import wily.betterfurnaces.blocks.SmeltingBlock;
import wily.betterfurnaces.client.ItemColorsHandler;
import wily.betterfurnaces.client.renderer.ForgeRenderer;
import wily.betterfurnaces.client.renderer.FurnaceRenderer;
import wily.betterfurnaces.client.screen.CobblestoneGeneratorScreen;
import wily.betterfurnaces.client.screen.ColorUpgradeScreen;
import wily.betterfurnaces.client.screen.ForgeScreen;
import wily.betterfurnaces.client.screen.FuelVerifierScreen;
import wily.betterfurnaces.client.screen.FurnaceScreen;
import wily.betterfurnaces.gitup.UpCheck;
import wily.betterfurnaces.init.BlockEntityTypes;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.init.Registration;

public class ClientSide {
    public static void init() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModObjects.FURNACE_CONTAINER.get()), FurnaceScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModObjects.FORGE_CONTAINER.get()), ForgeScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModObjects.COLOR_UPGRADE_CONTAINER.get()), ColorUpgradeScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModObjects.FUEL_VERIFIER_CONTAINER.get()), FuelVerifierScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModObjects.COB_GENERATOR_CONTAINER.get()), CobblestoneGeneratorScreen::new);
        Registration.BLOCK_ITEMS.forEach(block -> {
            if (block.get() instanceof SmeltingBlock) {
                ItemPropertiesRegistry.register((ItemLike)((Block)block.get()).m_5456_(), (ResourceLocation)new ResourceLocation("betterfurnacesreforged", "colored"), (stack, level, living, id) -> ItemColorsHandler.itemContainsColor(stack.m_41784_()) ? 1.0f : 0.0f);
            }
            ColorHandlerRegistry.registerItemColors((ItemColor)ItemColorsHandler.COLOR, (ItemLike[])new ItemLike[]{((Block)block.get()).m_5456_()});
        });
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)BlockEntityTypes.BETTER_FURNACE_TILE.get()), FurnaceRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)BlockEntityTypes.FORGE_TILE.get()), ForgeRenderer::new);
    }

    public static void registerExtraModels(Consumer<ResourceLocation> register) {
        SmeltingBlock.TYPE.m_6908_().forEach(i -> List.of(Boolean.valueOf(false), Boolean.valueOf(true)).forEach(b -> register.accept((ResourceLocation)FurnaceRenderer.getFront(i, b))));
        register.accept((ResourceLocation)new ModelResourceLocation(new ResourceLocation("betterfurnacesreforged:colored_furnace"), ""));
        register.accept((ResourceLocation)new ModelResourceLocation(new ResourceLocation("betterfurnacesreforged:colored_forge"), ""));
        register.accept((ResourceLocation)new ModelResourceLocation(new ResourceLocation("betterfurnacesreforged:colored_forge_on"), ""));
        register.accept((ResourceLocation)new ModelResourceLocation(new ResourceLocation("betterfurnacesreforged:nsweud"), ""));
    }

    public static void updateClientTick() {
        ClientTickEvent.ClientLevel listener = level -> {
            if (level != null) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (UpCheck.checkFailed) {
                    player.m_5661_((Component)Component.Serializer.m_130701_((String)I18n.m_118938_((String)"betterfurnacesreforged.update.failed", (Object[])new Object[0])), false);
                } else if (UpCheck.needsUpdateNotify) {
                    player.m_5661_((Component)Component.Serializer.m_130701_((String)I18n.m_118938_((String)"betterfurnacesreforged.update.speech", (Object[])new Object[0])), false);
                    player.m_5661_((Component)Component.Serializer.m_130701_((String)I18n.m_118938_((String)"betterfurnacesreforged.update.version", (Object[])new Object[]{"1.20.1-" + BetterFurnacesReforged.VERSION.get(), UpCheck.updateVersionString})), false);
                    player.m_5661_((Component)Component.Serializer.m_130701_((String)I18n.m_118938_((String)"betterfurnacesreforged.update.buttons", (Object[])new Object[]{"https://www.curseforge.com/minecraft/mc-mods/better-furnaces-reforged/"})), false);
                }
            }
        };
        ClientTickEvent.CLIENT_LEVEL_PRE.register((Object)listener);
        ClientTickEvent.CLIENT_LEVEL_POST.register(i -> {
            if (UpCheck.threadFinished && ClientTickEvent.CLIENT_LEVEL_PRE.isRegistered((Object)listener)) {
                ClientTickEvent.CLIENT_LEVEL_PRE.unregister((Object)listener);
            }
        });
    }
}

