/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blocks;

import dev.architectury.fluid.FluidStack;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.blocks.BFRBlock;
import wily.betterfurnaces.init.BlockEntityTypes;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.items.LiquidFuelUpgradeItem;
import wily.betterfurnaces.items.UpgradeItem;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.ItemContainerUtil;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.Storages;

public class SmeltingBlock
extends BFRBlock
implements EntityBlock {
    public static final BooleanProperty COLORED = BooleanProperty.m_61465_((String)"colored");
    public static final IntegerProperty TYPE = IntegerProperty.m_61631_((String)"type", (int)0, (int)3);
    public boolean shouldDropContent = true;
    public Supplier<Integer> defaultCookTime;

    public SmeltingBlock(BlockBehaviour.Properties properties, Supplier<Integer> defaultCookTime) {
        super(properties.m_155954_(3.0f).m_60953_(b -> (Boolean)b.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 14 : 0).m_60955_().m_60991_(SmeltingBlock::getOrientation));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)COLORED, (Comparable)Boolean.valueOf(false)));
        this.defaultCookTime = defaultCookTime;
    }

    public SmeltingBlock(BlockBehaviour.Properties properties, Item.Properties itemProperties, Supplier<Integer> defaultCookTime) {
        this(properties, defaultCookTime);
        this.itemProperties = itemProperties;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)ctx.m_8125_().m_122424_());
    }

    public static boolean getOrientation(BlockState state, BlockGetter world, BlockPos pos) {
        return world.m_7702_(pos) != null && ((SmeltingBlockEntity)world.m_7702_((BlockPos)pos)).showOrientation;
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack drop = new ItemStack((ItemLike)this.m_5456_());
        ItemStack stack = (ItemStack)builder.m_287159_(LootContextParams.f_81463_);
        BlockEntity be = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (EnchantmentHelper.m_44831_((ItemStack)stack).containsKey(Enchantments.f_44985_) && stack.m_41735_(state)) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("BlockEntityTag", (Tag)be.m_5995_());
            drop.m_41751_(tag);
        }
        return Collections.singletonList(drop);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState p_180633_3_, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            SmeltingBlockEntity be = (SmeltingBlockEntity)world.m_7702_(pos);
            if (stack.m_41788_()) {
                be.setCustomName(stack.m_41611_());
            }
            be.totalCookTime = this.defaultCookTime.get();
            be.forceUpdateAllStates();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        UpgradeItem upg;
        ItemStack stack = player.m_21120_(handIn).m_41777_();
        ItemStack hand = player.m_21120_(handIn);
        SmeltingBlockEntity be = (SmeltingBlockEntity)world.m_7702_(pos);
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Item item = hand.m_41720_();
        if (item instanceof UpgradeItem && (upg = (UpgradeItem)item).isEnabled() && !player.m_6047_()) {
            return this.interactUpgrade(world, pos, player, handIn, stack);
        }
        if (ItemContainerUtil.isFluidContainer((ItemStack)hand) && !player.m_6047_()) {
            Bearer fluidAmount = Bearer.of((Object)0L);
            if (be.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get())) && ItemContainerUtil.getFluid((ItemStack)stack).getFluid().m_6212_((Fluid)Fluids.f_76193_) && ItemContainerUtil.getFluid((ItemStack)be.getUpgradeSlotItem((Item)ModObjects.GENERATOR.get())).getAmount() <= 3L * FluidStack.bucketAmount()) {
                fluidAmount.set((Object)FactoryAPIPlatform.getItemFluidHandler((ItemStack)be.getUpgradeSlotItem((Item)ModObjects.GENERATOR.get())).fill(ItemContainerUtil.drainItem((long)FluidStack.bucketAmount(), (Player)player, (InteractionHand)handIn), false));
            } else if (be.hasUpgrade((UpgradeItem)((Object)ModObjects.LIQUID.get())) && LiquidFuelUpgradeItem.supportsFluid(ItemContainerUtil.getFluid((ItemStack)hand).getFluid())) {
                be.getStorage(Storages.FLUID, null).ifPresent(e -> {
                    if (e.getTotalSpace() > 0L && e.getFluidStack().isFluidEqual(ItemContainerUtil.getFluid((ItemStack)hand)) || e.getFluidStack().isEmpty()) {
                        fluidAmount.set((Object)e.fill(ItemContainerUtil.drainItem((long)e.getTotalSpace(), (Player)player, (InteractionHand)handIn), false));
                    }
                });
            }
            if ((Long)fluidAmount.get() > 0L) {
                return InteractionResult.SUCCESS;
            }
        }
        this.interactWith(world, pos, player);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult interactUpgrade(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack stack) {
        ItemStack hand = player.m_21120_(handIn);
        if (!(hand.m_41720_() instanceof UpgradeItem)) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof SmeltingBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        SmeltingBlockEntity be = (SmeltingBlockEntity)blockEntity;
        ItemStack newStack = new ItemStack((ItemLike)stack.m_41720_(), 1);
        newStack.m_41751_(stack.m_41783_());
        if (be.hasUpgradeType((UpgradeItem)stack.m_41720_())) {
            if (!player.m_7500_()) {
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), (ItemStack)be.getUpgradeTypeSlotItem((UpgradeItem)stack.m_41720_()));
            } else {
                be.getUpgradeTypeSlotItem((UpgradeItem)stack.m_41720_()).m_41774_(1);
            }
        }
        for (int upg : be.UPGRADES()) {
            if (!((FactoryItemSlot)be.getSlots(null).get(upg)).m_5857_(stack) || stack.m_41619_()) continue;
            if (!be.inventory.m_8020_(upg).m_41619_() && upg == be.UPGRADES()[be.UPGRADES().length - 1]) {
                if (!player.m_7500_()) {
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), (ItemStack)be.inventory.m_8020_(upg));
                } else {
                    be.inventory.m_8020_(upg).m_41774_(1);
                }
            }
            if (!be.inventory.m_8020_(upg).m_41619_()) continue;
            be.inventory.m_6836_(upg, newStack);
            if (!player.m_7500_()) {
                player.m_21120_(handIn).m_41774_(1);
            }
            world.m_5594_(null, be.m_58899_(), SoundEvents.f_11677_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        be.onUpdateSent();
        return InteractionResult.SUCCESS;
    }

    private void interactWith(Level world, BlockPos pos, Player player) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof ExtendedMenuProvider) {
            ExtendedMenuProvider menu = (ExtendedMenuProvider)tileEntity;
            MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)menu);
            player.m_36220_(Stats.f_12966_);
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41784_().m_128451_("type") == 1) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.betterfurnacesreforged.furnace.only", (Object[])new Object[]{new ItemStack((ItemLike)ModObjects.BLAST.get()).m_41786_().getString()}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_RED)));
        } else if (stack.m_41784_().m_128451_("type") == 2) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.betterfurnacesreforged.furnace.only", (Object[])new Object[]{new ItemStack((ItemLike)ModObjects.SMOKE.get()).m_41786_().getString()}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_RED)));
        }
        super.m_5871_(stack, worldIn, tooltip, flagIn);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            double d7;
            double d6;
            double d5;
            double d4;
            double d3;
            Direction.Axis direction$axis;
            Direction direction;
            double d2;
            double d1;
            double d0;
            int type = (Integer)state.m_61143_((Property)TYPE);
            if (type == 0 || type == 3) {
                if (world.m_7702_(pos) == null) {
                    return;
                }
                if (!(world.m_7702_(pos) instanceof SmeltingBlockEntity)) {
                    return;
                }
                d0 = (double)pos.m_123341_() + 0.5;
                d1 = pos.m_123342_();
                d2 = (double)pos.m_123343_() + 0.5;
                if (rand.m_188500_() < 0.1) {
                    world.m_7785_(d0, d1, d2, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                direction$axis = direction.m_122434_();
                d3 = 0.52;
                d4 = rand.m_188500_() * 0.6 - 0.3;
                d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
                d6 = rand.m_188500_() * 6.0 / 16.0;
                d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
            if (type == 1) {
                d0 = (double)pos.m_123341_() + 0.5;
                d1 = pos.m_123342_();
                d2 = (double)pos.m_123343_() + 0.5;
                if (rand.m_188500_() < 0.1) {
                    world.m_7785_(d0, d1, d2, SoundEvents.f_11715_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                direction$axis = direction.m_122434_();
                d3 = 0.52;
                d4 = rand.m_188500_() * 0.6 - 0.3;
                d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
                d6 = rand.m_188500_() * 9.0 / 16.0;
                d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
            if (type == 2) {
                d0 = (double)pos.m_123341_() + 0.5;
                d1 = pos.m_123342_();
                d2 = (double)pos.m_123343_() + 0.5;
                if (rand.m_188500_() < 0.1) {
                    world.m_7785_(d0, d1, d2, SoundEvents.f_12472_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1 + 1.1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        this.shouldDropContent = !EnchantmentHelper.m_44831_((ItemStack)stack).containsKey(Enchantments.f_44985_) || !stack.m_41735_(blockState);
        super.m_5707_(level, blockPos, blockState, player);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        if (state.m_60734_() != oldState.m_60734_()) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof SmeltingBlockEntity) {
                SmeltingBlockEntity smeltBe = (SmeltingBlockEntity)be;
                if (this.shouldDropContent) {
                    Containers.m_19002_((Level)world, (BlockPos)pos, (Container)smeltBe.inventory);
                    smeltBe.grantStoredRecipeExperience(world, Vec3.m_82512_((Vec3i)pos));
                }
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, oldState, p_196243_5_);
        }
    }

    public BlockState m_6843_(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)p_185499_2_.m_55954_((Direction)p_185499_1_.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public BlockState m_6943_(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.m_60717_(p_185471_2_.m_54846_((Direction)p_185471_1_.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public boolean m_7899_(BlockState p_149744_1_) {
        return true;
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        SmeltingBlockEntity be = (SmeltingBlockEntity)level.m_7702_(blockPos);
        if (be != null) {
            int i;
            int mode = be.furnaceSettings.get(8);
            int n = i = !be.hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get())) || mode == 3 || mode == 4 ? AbstractContainerMenu.m_38938_((Container)be.inventory) : 0;
            if (mode != 4) {
                return i;
            }
            return Math.max(i - be.furnaceSettings.get(9), 0);
        }
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61443_, COLORED, TYPE});
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BlockEntityTypes.BETTER_FURNACE_TILE.get()).m_155264_(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return SmeltingBlock.createFurnaceTicker(level, type, (BlockEntityType<? extends SmeltingBlockEntity>)((BlockEntityType)BlockEntityTypes.BETTER_FURNACE_TILE.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createFurnaceTicker(Level p_151988_, BlockEntityType<T> p_151989_, BlockEntityType<? extends SmeltingBlockEntity> p_151990_) {
        return p_151988_.f_46443_ ? null : SmeltingBlock.createTickerHelper(p_151989_, p_151990_, SmeltingBlockEntity::tick);
    }
}

