/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wily.factoryapi.base.client.drawable.IFactoryDrawableType;
import wily.factoryapi.util.FluidRenderUtil;

@OnlyIn(value=Dist.CLIENT)
public class ProgressElementRenderUtil {
    public static void renderDefaultProgress(GuiGraphics gui, int x, int y, float percentage, IFactoryDrawableType.DrawableProgress type) {
        int progress = Math.round(percentage * (float)(type.plane().isVertical() ? type.height() : type.width()));
        if (type.reverse()) {
            if (type.plane().isHorizontal()) {
                x += type.width() - progress;
            } else {
                y += type.height() - progress;
            }
        }
        if (progress > 0) {
            if (type.plane().isHorizontal()) {
                gui.m_280218_(type.texture(), x, y, type.uvX(), type.uvY(), progress, type.height());
            } else {
                gui.m_280218_(type.texture(), x, y + type.height() - progress, type.uvX(), type.uvY() + (type.height() - progress), type.width(), progress);
            }
        }
    }

    public static void renderFluidTank(GuiGraphics graphics, int x, int y, IFactoryDrawableType type, FluidStack stack, long capacity, boolean hasColor) {
        int progress;
        int n = progress = capacity <= 0L ? 0 : Math.round((float)stack.getAmount() / (float)capacity * (float)type.height());
        if (progress > 0) {
            RenderSystem.enableBlend();
            progress = (int)((double)progress / 1.3);
            int fluidWidth = type.width();
            int posY = y + type.height() - progress;
            TextureAtlasSprite fluidSprite = FluidRenderUtil.fluidSprite(stack, hasColor);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)fluidSprite.m_247685_());
            RenderSystem.setShader(GameRenderer::m_172817_);
            for (int i = 0; i < fluidWidth; i += 16) {
                for (int j = 0; j < progress; j += 16) {
                    FluidRenderUtil.renderTiledFluid(graphics, x, posY, i, j, progress, fluidWidth, fluidSprite);
                }
            }
            RenderSystem.disableBlend();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)type.texture());
        type.draw(graphics, x, y);
    }
}

