/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.forge;

import dev.architectury.platform.forge.EventBuses;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.IFactoryItem;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.Storages;
import wily.factoryapi.forge.base.CapabilityUtil;

@Mod(value="factory_api")
@Mod.EventBusSubscriber(modid="factory_api", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FactoryAPIForge {
    public FactoryAPIForge() {
        EventBuses.registerModEventBus((String)"factory_api", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        FactoryAPI.init();
    }

    @SubscribeEvent
    public static void attachBECapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object = event.getObject();
        if (object instanceof IFactoryStorage) {
            final IFactoryStorage be = (IFactoryStorage)object;
            event.addCapability(new ResourceLocation("factory_api", "factory_api_capabilities"), new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                    Storages.Storage<? extends IPlatformHandler> storage = CapabilityUtil.capabilityToStorage(capability);
                    ArbitrarySupplier<? extends IPlatformHandler> handler = be.getStorage(storage, arg);
                    if (storage != null && handler.isPresent()) {
                        return LazyOptional.of(handler::get).cast();
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }

    @SubscribeEvent
    public static void attachItemCapabilities(final AttachCapabilitiesEvent<ItemStack> event) {
        Item item = ((ItemStack)event.getObject()).m_41720_();
        if (item instanceof IFactoryItem) {
            final IFactoryItem s = (IFactoryItem)item;
            event.addCapability(new ResourceLocation("factory_api", "factory_api_capabilities"), new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                    Storages.Storage<? extends IPlatformHandler> storage = CapabilityUtil.capabilityToStorage(capability);
                    ArbitrarySupplier<? extends IPlatformHandler> handler = s.getStorage(storage, (ItemStack)event.getObject());
                    if (storage != null && handler.isPresent()) {
                        return LazyOptional.of(handler::get).cast();
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }
}

