/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import wily.factoryapi.base.client.IWindowWidget;
import wily.factoryapi.base.client.drawable.AbstractDrawableButton;
import wily.factoryapi.base.client.drawable.DrawableStatic;
import wily.factoryapi.base.client.drawable.IFactoryDrawableType;
import wily.factoryapi.util.ScreenUtil;

public abstract class FactoryScreenWindow<T extends AbstractContainerScreen<?>>
extends AbstractWidget
implements IWindowWidget {
    public final AbstractDrawableButton<?> config;
    private double actualMouseX;
    private double actualMouseY;
    public boolean dragging = false;
    public boolean useGeneratedBackground;
    protected final ItemRenderer itemRenderer;
    protected final Font font;
    protected final List<Renderable> nestedRenderables;
    protected final DrawableStatic drawable;
    public T parent;
    int lastX;
    int lastY;

    public FactoryScreenWindow(AbstractDrawableButton<?> config, DrawableStatic drawable, T parent) {
        super(drawable.m_110085_(), drawable.m_110086_(), drawable.width(), drawable.height(), (Component)Component.m_237119_());
        this.font = Minecraft.m_91087_().f_91062_;
        this.nestedRenderables = new ArrayList<Renderable>();
        this.config = config;
        this.lastX = this.m_252754_();
        this.lastY = this.m_252907_();
        this.parent = parent;
        this.drawable = drawable;
        this.itemRenderer = Minecraft.m_91087_().m_91291_();
    }

    @Override
    public boolean isVisible() {
        return this.config.selected == Boolean.TRUE && (Boolean)this.config.visible.get() != false;
    }

    public void onClose() {
        this.config.selected = false;
        Consumer<FactoryScreenWindow> onClick = w -> {
            if (w.isVisible()) {
                w.onClickWidget();
            }
        };
        this.parent.m_6702_().forEach(l -> {
            if (l instanceof FactoryScreenWindow) {
                FactoryScreenWindow s = (FactoryScreenWindow)l;
                onClick.accept(s);
            }
        });
        T t = this.parent;
        if (t instanceof IWindowWidget) {
            IWindowWidget w2 = (IWindowWidget)t;
            w2.getNestedRenderables().forEach(l -> {
                if (l instanceof FactoryScreenWindow) {
                    FactoryScreenWindow s = (FactoryScreenWindow)l;
                    onClick.accept(s);
                }
            });
        }
    }

    public void onClickWidget() {
        this.f_93625_ = 1.0f;
        this.parent.m_7522_((GuiEventListener)this);
    }

    public void onClickOutside(double mouseX, double mouseY) {
        this.m_93692_(false);
        this.f_93625_ = 0.88f;
    }

    public boolean m_7933_(int i, int j, int k) {
        if (i == 256 && this.isVisible()) {
            this.onClose();
            return true;
        }
        return false;
    }

    protected void renderBg(GuiGraphics graphics, int i, int j, float f) {
        graphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        if (this.useGeneratedBackground) {
            ScreenUtil.drawGUIBackground(graphics, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
        } else {
            this.drawable.draw(graphics, this.m_252754_(), this.m_252907_());
        }
        IWindowWidget.super.m_88315_(graphics, i, j, f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        graphics.m_280168_().m_85849_();
    }

    @Override
    public List<? extends Renderable> getNestedRenderables() {
        return this.nestedRenderables;
    }

    @Override
    public <R extends Renderable> R addNestedRenderable(R drawable) {
        this.nestedRenderables.add(drawable);
        return drawable;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int i, int j, float f) {
        if (!this.isVisible()) {
            return;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(0.0, 0.0, (double)this.getBlitOffset());
        this.renderBg(graphics, i, j, f);
        this.m_87963_(graphics, i, j, f);
        this.renderToolTip(graphics, i, j);
        graphics.m_280168_().m_85849_();
    }

    public float getBlitOffset() {
        return 450.0f;
    }

    public void renderToolTip(GuiGraphics graphics, int i, int j) {
    }

    public boolean m_5953_(double d, double e) {
        return this.isVisible() && IFactoryDrawableType.getMouseLimit(d, e, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
    }

    public void updateActualMouse(double mouseX, double mouseY) {
        this.actualMouseX = mouseX;
        this.actualMouseY = mouseY;
    }

    public void updateLastMouse(int mouseX, int mouseY) {
        this.lastX = mouseX;
        this.lastY = mouseY;
    }

    @Override
    public boolean m_6375_(double d, double e, int i) {
        if (!this.isVisible()) {
            return false;
        }
        if (i == 0) {
            if (this.m_5953_(d, e) || this.config.m_5953_(d, e)) {
                this.onClickWidget();
                if (this.m_5953_(d, e)) {
                    this.updateActualMouse(d, e);
                }
            } else {
                this.onClickOutside(d, e);
            }
        }
        return IWindowWidget.super.m_6375_(d, e, i);
    }

    @Override
    public boolean m_6348_(double d, double e, int i) {
        if (this.dragging) {
            this.dragging = false;
            this.parent.m_7897_(false);
            this.updateLastMouse(this.m_252754_(), this.m_252907_());
            return true;
        }
        return IWindowWidget.super.m_6348_(d, e, i);
    }

    @Override
    public boolean m_7979_(double d, double e, int i, double f, double g) {
        if (!this.isVisible() || this.parent.m_7282_() && !this.dragging) {
            return false;
        }
        if (IWindowWidget.super.m_7979_(d, e, i, f, g)) {
            return true;
        }
        if (i == 0 && (this.m_5953_(d, e) || this.dragging)) {
            double newX = (double)this.lastX + d - this.actualMouseX;
            double newY = (double)this.lastY + e - this.actualMouseY;
            if (newX + (double)this.f_93618_ < (double)((AbstractContainerScreen)this.parent).f_96543_ && newX > 0.0) {
                this.m_252865_((int)newX);
            }
            if (newY + (double)this.f_93619_ < (double)((AbstractContainerScreen)this.parent).f_96544_ && newY > 0.0) {
                this.m_253211_((int)newY);
            }
            this.dragging = true;
            this.parent.m_7897_(true);
            return true;
        }
        return false;
    }

    @Override
    public Rect2i getBounds() {
        return new Rect2i(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
    }
}

