/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.BlockSide;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.IHasIdentifier;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.SideList;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.Storages;
import wily.factoryapi.base.TransportSide;

public interface IFactoryExpandedStorage
extends IFactoryStorage {
    default public void replaceSidedStorage(BlockSide blockSide, SideList<TransportSide> side, TransportSide replacement) {
        IFactoryExpandedStorage iFactoryExpandedStorage = this;
        if (iFactoryExpandedStorage instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)iFactoryExpandedStorage;
            side.put(blockSide.blockStateToFacing(be.m_58900_()), replacement);
        }
    }

    default public NonNullList<FactoryItemSlot> getSlots(@Nullable Player player) {
        return NonNullList.m_122779_();
    }

    default public List<IPlatformFluidHandler> getTanks() {
        return NonNullList.m_122779_();
    }

    default public Map<SlotsIdentifier, int[]> itemSlotsIdentifiers() {
        LinkedHashMap<SlotsIdentifier, int[]> map = new LinkedHashMap<SlotsIdentifier, int[]>();
        for (FactoryItemSlot slot : this.getSlots(null)) {
            int[] list = map.getOrDefault(slot.identifier(), new int[0]);
            if (ArrayUtils.contains((int[])list, (int)slot.m_150661_())) continue;
            list = ArrayUtils.add((int[])list, (int)slot.m_150661_());
            map.put(slot.identifier(), list);
        }
        return map;
    }

    default public List<Direction> getBlockedSides() {
        return Collections.emptyList();
    }

    default public List<SlotsIdentifier> getItemSlotsIdentifiers() {
        return List.copyOf(this.itemSlotsIdentifiers().keySet());
    }

    default public List<SlotsIdentifier> getFluidSlotsIdentifiers() {
        return IHasIdentifier.getSlotsIdentifiers(this.getTanks());
    }

    default public void loadTag(CompoundTag compoundTag) {
        this.getStorage(Storages.CRAFTY_ENERGY).ifPresent(e -> e.deserializeTag(compoundTag.m_128469_("CYEnergy")));
        this.getStorage(Storages.ENERGY).ifPresent(e -> e.deserializeTag(compoundTag.m_128469_("Energy")));
        if (!this.getTanks().isEmpty()) {
            this.getTanks().forEach(tank -> tank.deserializeTag(compoundTag.m_128469_(tank.getName())));
        }
        this.getStorage(Storages.ITEM).ifPresent(e -> e.deserializeTag((Tag)compoundTag.m_128469_("inventory")));
        this.getStorageSides(Storages.FLUID).ifPresent(f -> TransportSide.deserializeTag(compoundTag.m_128469_("fluidSides"), f, this.getTanks()));
        this.getStorageSides(Storages.ITEM).ifPresent(i -> TransportSide.deserializeTag(compoundTag.m_128469_("itemSides"), i, this.getItemSlotsIdentifiers()));
        this.getStorageSides(Storages.CRAFTY_ENERGY).ifPresent(e -> TransportSide.deserializeTag(compoundTag.m_128469_("energySides"), e));
    }

    default public void saveTag(CompoundTag compoundTag) {
        this.getStorage(Storages.CRAFTY_ENERGY).ifPresent(e -> compoundTag.m_128365_("CYEnergy", e.serializeTag()));
        this.getStorage(Storages.ENERGY).ifPresent(e -> compoundTag.m_128365_("Energy", e.serializeTag()));
        if (!this.getTanks().isEmpty()) {
            this.getTanks().forEach(tank -> compoundTag.m_128365_(tank.getName(), tank.serializeTag()));
        }
        this.getStorage(Storages.ITEM).ifPresent(i -> compoundTag.m_128365_("inventory", i.serializeTag()));
        this.getStorageSides(Storages.FLUID).ifPresent(f -> compoundTag.m_128365_("fluidSides", (Tag)TransportSide.serializeTag(f, this.getTanks())));
        this.getStorageSides(Storages.ITEM).ifPresent(i -> compoundTag.m_128365_("itemSides", (Tag)TransportSide.serializeTag(i, this.getItemSlotsIdentifiers())));
        this.getStorageSides(Storages.CRAFTY_ENERGY).ifPresent(e -> compoundTag.m_128365_("energySides", (Tag)TransportSide.serializeTag(e)));
    }
}

