/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import wily.factoryapi.base.FactoryEnergyStorage;
import wily.factoryapi.base.TransportState;

public class FactoryItemEnergyStorage
extends FactoryEnergyStorage {
    ItemStack container;

    public FactoryItemEnergyStorage(ItemStack stack, int initialEnergy, int capacity, int maxOutput, int maxInput, TransportState transportState) {
        super(capacity, null, transportState);
        this.container = stack;
        if (!stack.m_41784_().m_128441_("energy")) {
            this.setEnergyStored(initialEnergy);
        }
        this.maxOutput = maxOutput;
        this.maxInput = maxInput;
    }

    public FactoryItemEnergyStorage(ItemStack stack, int capacity, TransportState transportState) {
        this(stack, 0, capacity, capacity, capacity, transportState);
    }

    @Override
    public int receiveEnergy(int receive, boolean simulate) {
        int energyReceived = Math.min(this.getEnergySpace(), Math.min(this.getMaxReceive(), receive));
        int energy = this.getEnergyStored();
        if (!simulate) {
            this.setEnergyStored(energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int consumeEnergy(int consume, boolean simulate) {
        int energy = this.getEnergyStored();
        int energyExtracted = Math.min(energy, Math.min(this.getMaxConsume(), consume));
        if (!simulate) {
            this.setEnergyStored(energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored() {
        return this.container.m_41784_().m_128451_("energy");
    }

    @Override
    public void setEnergyStored(int energy) {
        this.container.m_41784_().m_128405_("energy", energy);
    }

    @Override
    public CompoundTag serializeTag() {
        return this.container.m_41784_();
    }

    @Override
    public void deserializeTag(CompoundTag nbt) {
        this.container.m_41751_(nbt);
    }

    @Override
    public int getMaxConsume() {
        return Math.min(this.getEnergyStored(), this.maxOutput);
    }

    @Override
    public int getMaxReceive() {
        return Math.min(this.getMaxEnergyStored(), this.maxInput);
    }
}

