/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import dev.architectury.fluid.FluidStack;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.IModifiableTransportHandler;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.FluidStackUtil;

public class FactoryFluidHandler
implements IPlatformFluidHandler {
    long capacity;
    private final BlockEntity be;
    public FluidStack fluid = FluidStack.empty();
    private final Predicate<FluidStack> validator;
    private final SlotsIdentifier differential;
    protected TransportState transportState;

    public FactoryFluidHandler(long capacity, BlockEntity be) {
        this(capacity, be, f -> true, SlotsIdentifier.GENERIC, TransportState.EXTRACT_INSERT);
    }

    public FactoryFluidHandler(long capacity, @Nullable BlockEntity be, Predicate<FluidStack> validator, SlotsIdentifier differential, TransportState transport) {
        this.capacity = capacity;
        this.be = be;
        this.validator = validator;
        this.differential = differential;
        this.transportState = transport;
    }

    @Override
    public boolean isRemoved() {
        return this.be != null && this.be.m_58901_();
    }

    @Override
    public void m_6596_() {
        if (this.be != null) {
            this.be.m_6596_();
        }
    }

    @Override
    @NotNull
    public FluidStack getFluidStack() {
        return this.fluid;
    }

    @Override
    public long getMaxFluid() {
        return this.capacity;
    }

    @Override
    public void deserializeTag(CompoundTag tag) {
        this.setFluid(FluidStackUtil.fromTag(tag));
        if (tag.m_128441_("capacity")) {
            this.setCapacity(tag.m_128454_("capacity"));
        }
    }

    @Override
    public CompoundTag serializeTag() {
        CompoundTag tag = FluidStackUtil.toTag(this.getFluidStack());
        tag.m_128356_("capacity", this.getMaxFluid());
        return tag;
    }

    @Override
    public boolean isFluidValid(@NotNull FluidStack stack) {
        return this.validator.test(stack);
    }

    @Override
    public long fill(FluidStack resource, boolean simulate) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0L;
        }
        if (simulate) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0L;
            }
            return Math.min(this.capacity - this.fluid.getAmount(), resource.getAmount());
        }
        if (this.fluid.isEmpty()) {
            this.fluid = FluidStack.create((FluidStack)resource, (long)Math.min(this.capacity, resource.getAmount()));
            this.m_6596_();
            return this.fluid.getAmount();
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0L;
        }
        long filled = this.capacity - this.fluid.getAmount();
        if (resource.getAmount() < filled) {
            this.fluid.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluid.setAmount(this.capacity);
        }
        if (filled > 0L) {
            this.m_6596_();
        }
        return filled;
    }

    @Override
    @NotNull
    public FluidStack drain(FluidStack resource, boolean simulate) {
        if (!resource.isFluidEqual(this.getFluidStack())) {
            return FluidStack.empty();
        }
        return this.drain(resource.getAmount(), simulate);
    }

    @Override
    @NotNull
    public FluidStack drain(long maxDrain, boolean simulate) {
        if (!this.getTransport().canExtract()) {
            return FluidStack.empty();
        }
        long drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidStack stack = FluidStack.create((FluidStack)this.fluid, (long)drained);
        if (!simulate && drained > 0L) {
            this.fluid.shrink(drained);
            this.m_6596_();
        }
        return stack;
    }

    @Override
    public void setFluid(FluidStack fluidStack) {
        this.fluid = fluidStack;
    }

    @Override
    public SlotsIdentifier identifier() {
        return this.differential;
    }

    @Override
    public TransportState getTransport() {
        return this.transportState;
    }

    @Override
    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public static class SidedWrapper
    extends FactoryFluidHandler
    implements IModifiableTransportHandler {
        private final IPlatformFluidHandler fluidHandler;

        public SidedWrapper(IPlatformFluidHandler fluidHandler) {
            super(fluidHandler.getMaxFluid(), ((FactoryFluidHandler)fluidHandler).be, fluidHandler::isFluidValid, fluidHandler.identifier(), fluidHandler.getTransport());
            this.fluidHandler = fluidHandler;
        }

        @Override
        @NotNull
        public FluidStack drain(long maxDrain, boolean simulate) {
            return this.fluidHandler.drain(maxDrain, simulate);
        }

        @Override
        public long fill(FluidStack fluid, boolean simulate) {
            return this.fluidHandler.fill(fluid, simulate);
        }

        @Override
        public FluidStack getFluidStack() {
            return this.fluidHandler.getFluidStack();
        }

        @Override
        public void setFluid(FluidStack stack) {
            this.fluidHandler.setFluid(stack);
        }

        @Override
        public void setTransport(TransportState state) {
            this.transportState = state;
        }
    }
}

