/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ArbitrarySupplier<T>
extends Supplier<T> {
    public static <T> ArbitrarySupplier<T> empty() {
        return () -> null;
    }

    public static <T> ArbitrarySupplier<T> of(T object) {
        return () -> object;
    }

    default public <O> Object orObject(@NotNull O alternative) {
        return this.isPresent() ? this.get() : alternative;
    }

    default public T or(@NotNull T alternative) {
        return this.or(() -> alternative).get();
    }

    default public ArbitrarySupplier<T> or(ArbitrarySupplier<@NotNull T> alternative) {
        return this.isPresent() ? this : alternative;
    }

    default public void ifPresent(Consumer<T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
    }

    default public boolean isPresent() {
        return !this.isEmpty();
    }

    default public boolean isEmpty() {
        return this.get() == null;
    }

    default public boolean isPresentAnd(Predicate<T> predicate) {
        return this.isPresent() && predicate.test(this.get());
    }

    default public <U> ArbitrarySupplier<U> cast() {
        return this;
    }

    default public Optional<T> optional() {
        return Optional.ofNullable(this.get());
    }
}

