/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi;

import dev.architectury.fluid.FluidStack;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import wily.factoryapi.base.FactoryEnergyStorage;
import wily.factoryapi.base.FactoryFluidHandler;
import wily.factoryapi.base.FactoryItemHandler;
import wily.factoryapi.base.ICraftyEnergyStorage;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.IModifiableTransportHandler;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.SideList;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.forge.FactoryAPIPlatformImpl;

public class FactoryAPIPlatform {
    public static final Map<IPlatformHandler, SideList<? super IModifiableTransportHandler>> filteredHandlersCache = new ConcurrentHashMap<IPlatformHandler, SideList<? super IModifiableTransportHandler>>();
    public static final Map<BlockEntity, IFactoryStorage> platformStorageWrappersCache = new ConcurrentHashMap<BlockEntity, IFactoryStorage>();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigDirectory() {
        return FactoryAPIPlatformImpl.getConfigDirectory();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Component getPlatformEnergyComponent() {
        return FactoryAPIPlatformImpl.getPlatformEnergyComponent();
    }

    @Deprecated
    public static IPlatformFluidHandler getFluidHandlerApi(long capacity, BlockEntity be, Predicate<FluidStack> validator, SlotsIdentifier differential, TransportState transport) {
        return new FactoryFluidHandler(capacity, be, validator, differential, transport);
    }

    @Deprecated
    public static IPlatformItemHandler getItemHandlerApi(int inventorySize, BlockEntity be) {
        return new FactoryItemHandler(inventorySize, be, TransportState.EXTRACT_INSERT);
    }

    @Deprecated
    public static IPlatformEnergyStorage getEnergyStorageApi(int capacity, BlockEntity be) {
        return new FactoryEnergyStorage(capacity, be);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IPlatformFluidHandler getItemFluidHandler(ItemStack container) {
        return FactoryAPIPlatformImpl.getItemFluidHandler(container);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IPlatformEnergyStorage getItemEnergyStorage(ItemStack stack) {
        return FactoryAPIPlatformImpl.getItemEnergyStorage(stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ICraftyEnergyStorage getItemCraftyEnergyStorage(ItemStack stack) {
        return FactoryAPIPlatformImpl.getItemCraftyEnergyStorage(stack);
    }

    public static <T extends IPlatformHandler, U extends IModifiableTransportHandler & IPlatformHandler> U filteredOf(T handler, Direction direction, TransportState transportState, Function<T, U> sidedGetter) {
        filteredHandlersCache.entrySet().removeIf(e -> ((IPlatformHandler)e.getKey()).isRemoved());
        SideList list = filteredHandlersCache.computeIfAbsent(handler, d -> new SideList<IModifiableTransportHandler>(() -> null));
        if (!list.contains(direction)) {
            list.put(direction, (IModifiableTransportHandler)sidedGetter.apply(handler));
        }
        list.get(direction).setTransport(transportState);
        return list.get(direction) != null ? (U)list.get(direction) : null;
    }

    public static IPlatformItemHandler filteredOf(IPlatformItemHandler itemHandler, Direction direction, int[] slots, TransportState transportState) {
        FactoryItemHandler.SidedWrapper storage = FactoryAPIPlatform.filteredOf(itemHandler, direction, transportState, FactoryItemHandler.SidedWrapper::new);
        if (storage != null) {
            storage.slots = slots;
        }
        return storage;
    }

    public static IPlatformFluidHandler filteredOf(IPlatformFluidHandler fluidHandler, Direction direction, TransportState transportState) {
        return FactoryAPIPlatform.filteredOf((FactoryFluidHandler)fluidHandler, direction, transportState, FactoryFluidHandler.SidedWrapper::new);
    }

    public static IPlatformEnergyStorage filteredOf(IPlatformEnergyStorage energyStorage, Direction direction, TransportState transportState) {
        return FactoryAPIPlatform.filteredOf((FactoryEnergyStorage)energyStorage, direction, transportState, FactoryEnergyStorage.SidedWrapper::new);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IFactoryStorage getPlatformFactoryStorage(BlockEntity entity) {
        return FactoryAPIPlatformImpl.getPlatformFactoryStorage(entity);
    }
}

