/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.core;

import com.almostreliable.lootjs.core.ILootCondition;
import com.almostreliable.lootjs.kube.LootConditionsContainer;
import com.almostreliable.lootjs.loot.LootFunctionsContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;

public class LootEntry
implements LootFunctionsContainer<LootEntry> {
    private final ItemStack itemStack;
    private final List<LootItemFunction> postModifications = new ArrayList<LootItemFunction>();
    private final List<ILootCondition> conditions = new ArrayList<ILootCondition>();
    private int weight = 1;

    public LootEntry(Item item) {
        this.itemStack = new ItemStack((ItemLike)item);
    }

    public LootEntry(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Nullable
    public ItemStack createItem(LootContext context) {
        if (!this.matchesConditions(context)) {
            return null;
        }
        if (this.itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = this.itemStack.m_41777_();
        for (LootItemFunction lootItemFunction : this.postModifications) {
            result = (ItemStack)lootItemFunction.apply((Object)result, (Object)context);
        }
        return result;
    }

    @Override
    public LootEntry addFunction(LootItemFunction lootItemFunction) {
        this.postModifications.add(lootItemFunction);
        return this;
    }

    public boolean matchesConditions(LootContext context) {
        for (ILootCondition condition : this.conditions) {
            if (condition.test(context)) continue;
            return false;
        }
        return true;
    }

    public boolean hasWeight() {
        return this.weight >= 1;
    }

    public int getWeight() {
        return this.weight;
    }

    public LootEntry withWeight(int weight) {
        this.weight = Math.max(1, weight);
        return this;
    }

    public LootEntry withChance(int chance) {
        return this.withWeight(chance);
    }

    public LootEntry when(Consumer<LootConditionsContainer<?>> action) {
        final ArrayList conditions = new ArrayList();
        LootConditionsContainer lcc = new LootConditionsContainer<LootConditionsContainer<?>>(){

            @Override
            public LootConditionsContainer<?> addCondition(ILootCondition condition) {
                conditions.add(condition);
                return this;
            }
        };
        action.accept(lcc);
        this.conditions.addAll(conditions);
        return this;
    }
}

