/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.CoralPlantBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.KelpPlantBlock;
import net.minecraft.world.level.block.MelonBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.SmallDripleafBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;

public class GrowingUtil {
    static boolean staffFarmerReplant = (Boolean)GobberConfigBuilder.STAFF_FARMER_REPLANT.get();
    static boolean staffHarvestBreaking = (Boolean)GobberConfigBuilder.STAFF_HARVEST_BREAKING.get();

    public static void growCrops(Level world, Player player, int baseTickDelay, int radius) {
        BlockPos playerPos = new BlockPos((Vec3i)player.m_20097_());
        for (BlockPos targetPos : BlockPos.m_121940_((BlockPos)playerPos.m_7918_(-radius, -2, -radius), (BlockPos)playerPos.m_7918_(radius, 3, radius))) {
            BlockState blockstate = world.m_8055_(targetPos);
            Block block = blockstate.m_60734_();
            if ((blockstate.m_60734_() instanceof CropBlock || block instanceof SaplingBlock || block instanceof VineBlock || block instanceof SugarCaneBlock || block instanceof SweetBerryBushBlock || block instanceof NetherWartBlock || block instanceof CactusBlock || block instanceof StemBlock || block instanceof MelonBlock || block instanceof PumpkinBlock || block instanceof BuddingAmethystBlock || block instanceof BigDripleafStemBlock || block instanceof SmallDripleafBlock || block instanceof AzaleaBlock) && player.f_19797_ % baseTickDelay == 0) {
                blockstate.m_222972_((ServerLevel)world, targetPos, world.f_46441_);
            }
            if ((block instanceof BambooSaplingBlock || block instanceof BambooStalkBlock || block instanceof CocoaBlock || block instanceof StemGrownBlock || block instanceof CoralPlantBlock || block instanceof CoralBlock || block instanceof TallSeagrassBlock || block instanceof SeagrassBlock || block instanceof KelpBlock || block instanceof KelpPlantBlock || block instanceof SeaPickleBlock || block instanceof ChorusFlowerBlock) && player.f_19797_ % (baseTickDelay * 2) == 0) {
                blockstate.m_222972_((ServerLevel)world, targetPos, world.f_46441_);
            }
            if (block instanceof GrassBlock && player.m_6144_() && player.f_19797_ % (baseTickDelay * 6) == 0) {
                ((GrassBlock)block).m_214148_((ServerLevel)world, world.f_46441_, targetPos, blockstate);
            }
            if (!(block instanceof FungusBlock) || player.f_19797_ % (baseTickDelay * 6) != 0) continue;
            ((FungusBlock)block).m_214148_((ServerLevel)world, world.f_46441_, targetPos, blockstate);
        }
    }

    public static void harvestCrops(Level world, Player player, int radius) {
        if (!world.f_46443_) {
            BlockPos playerPos = new BlockPos((Vec3i)player.m_20097_());
            for (BlockPos targetPos : BlockPos.m_121940_((BlockPos)playerPos.m_7918_(-radius, -2, -radius), (BlockPos)playerPos.m_7918_(radius, 6, radius))) {
                boolean atMaxAge;
                Block block = world.m_8055_(targetPos).m_60734_();
                BlockPos posAbove = targetPos.m_7494_();
                Block blockAbove = world.m_8055_(posAbove).m_60734_();
                BlockState state = world.m_8055_(targetPos);
                BlockState defaultState = block.m_49966_();
                if (staffHarvestBreaking) {
                    if (block instanceof CocoaBlock || block instanceof MelonBlock || block instanceof PumpkinBlock || block instanceof NetherWartBlock) {
                        world.m_46961_(targetPos, true);
                    }
                    if ((block instanceof CactusBlock || block instanceof SugarCaneBlock || block instanceof BambooStalkBlock) && block == blockAbove) {
                        world.m_46961_(posAbove, true);
                    }
                }
                if (!(block instanceof CropBlock) || !(atMaxAge = ((CropBlock)block).m_52305_(state) >= ((CropBlock)block).m_7419_())) continue;
                world.m_46961_(targetPos, true);
                if (!staffFarmerReplant) continue;
                world.m_46597_(targetPos, defaultState);
            }
        }
    }
}

