/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.util.modkeymapping;

import com.github.leawind.util.modkeymapping.ModKeyMapping;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModKeyMappingImpl
extends KeyMapping
implements ModKeyMapping {
    private long holdLength = 300L;
    private long pressLength = 300L;
    private long keyDownTime = 0L;
    @Nullable
    private Timer timer = null;
    @Nullable
    private Supplier<Boolean> ondown = null;
    @Nullable
    private Supplier<Boolean> onup = null;
    @Nullable
    private Supplier<Boolean> onhold = null;
    @Nullable
    private Supplier<Boolean> onpress = null;

    private static boolean handle(@Nullable Supplier<Boolean> handler) {
        return handler != null && handler.get() != false;
    }

    public ModKeyMappingImpl(String id, int defaultValue, String categoryKey) {
        super(id, defaultValue, categoryKey);
        mappings.put(id, this);
    }

    @Override
    public boolean m_90857_() {
        return super.m_90857_();
    }

    public void m_7249_(boolean down) {
        boolean wasDown = this.m_90857_();
        super.m_7249_(down);
        long now = System.currentTimeMillis();
        if (!wasDown && down) {
            if (ModKeyMappingImpl.handle(this.ondown)) {
                return;
            }
            this.keyDownTime = now;
            if (this.onhold != null) {
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        ModKeyMappingImpl.handle(ModKeyMappingImpl.this.onhold);
                        ModKeyMappingImpl.this.timer = null;
                    }
                }, this.holdLength);
            }
        } else if (wasDown && !down) {
            long sinceKeydown = now - this.keyDownTime;
            if (ModKeyMappingImpl.handle(this.onup)) {
                return;
            }
            if (sinceKeydown < this.pressLength) {
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
                ModKeyMappingImpl.handle(this.onpress);
            }
        }
    }

    @Override
    public ModKeyMappingImpl holdLength(long holdLength) {
        this.holdLength = holdLength;
        return this;
    }

    @Override
    public ModKeyMappingImpl pressLength(long pressLength) {
        this.pressLength = pressLength;
        return this;
    }

    @Override
    public ModKeyMappingImpl onDown(@NotNull Runnable handler) {
        return this.onDown(() -> {
            handler.run();
            return false;
        });
    }

    @Override
    public ModKeyMappingImpl onDown(@NotNull Supplier<Boolean> handler) {
        this.ondown = handler;
        return this;
    }

    @Override
    public ModKeyMappingImpl onUp(@NotNull Runnable handler) {
        return this.onUp(() -> {
            handler.run();
            return false;
        });
    }

    @Override
    public ModKeyMappingImpl onUp(@NotNull Supplier<Boolean> handler) {
        this.onup = handler;
        return this;
    }

    @Override
    public ModKeyMappingImpl onPress(@NotNull Runnable handler) {
        return this.onPress(() -> {
            handler.run();
            return false;
        });
    }

    @Override
    public ModKeyMappingImpl onPress(@NotNull Supplier<Boolean> handler) {
        this.onpress = handler;
        return this;
    }

    @Override
    public ModKeyMappingImpl onHold(@NotNull Runnable handler) {
        return this.onHold(() -> {
            handler.run();
            return false;
        });
    }

    @Override
    public ModKeyMappingImpl onHold(@NotNull Supplier<Boolean> handler) {
        this.onhold = handler;
        return this;
    }
}

