/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.util.math.monolist;

import com.github.leawind.util.math.LMath;
import com.github.leawind.util.math.monolist.MonoList;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class DeferedMonoList
implements MonoList {
    private final int length;
    @NotNull
    private final Function<Integer, Double> getter;
    private final int sgn;

    @NotNull
    public static DeferedMonoList exp(int length) {
        return new DeferedMonoList(length, Math::exp);
    }

    @NotNull
    public static DeferedMonoList squared(int length) {
        return new DeferedMonoList(length, i -> i * i);
    }

    @NotNull
    public static DeferedMonoList of(int length, @NotNull Function<Integer, Double> getter) {
        return new DeferedMonoList(length, getter);
    }

    protected DeferedMonoList(int length, @NotNull Function<Integer, Double> getter) {
        this.length = length;
        this.getter = getter;
        this.sgn = getter.apply(1) > getter.apply(0) ? 1 : -1;
    }

    @Override
    public double get(int i) {
        return this.getter.apply(i);
    }

    @Override
    public double offset(double value, int offset) {
        int i = this.iadsorption(value) + offset;
        i = LMath.clamp(i, 0, this.length() - 1);
        return this.get(i);
    }

    @Override
    public int iadsorption(double value) {
        int iLeft = 0;
        int iRight = this.length() - 1;
        int iCenter = this.length() / 2;
        while (true) {
            double vi;
            if ((vi = this.get(iCenter)) < value) {
                iLeft = iCenter;
            } else if (vi > value) {
                iRight = iCenter;
            } else {
                return iCenter;
            }
            if (iRight - iLeft == 1) break;
            iCenter = (iLeft + iRight) / 2;
        }
        double min = value - this.get(iLeft);
        double max = this.get(iRight) - value;
        if (min <= max) {
            return iLeft;
        }
        return iRight;
    }

    @Override
    public double adsorption(double value) {
        return this.get(this.iadsorption(value));
    }

    @Override
    public double getNext(double value) {
        return this.offset(value, 1);
    }

    @Override
    public double getLast(double value) {
        return this.offset(value, -1);
    }

    @Override
    public int sgn() {
        return this.sgn;
    }

    @Override
    public int length() {
        return this.length;
    }
}

