/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.mixin;

import com.github.leawind.api.base.GameEvents;
import com.github.leawind.api.client.event.RenderTickStartEvent;
import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonStatus;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class}, priority=2000)
public abstract class GameRendererMixin {
    @Shadow
    @Final
    Minecraft f_109059_;
    @Final
    @Shadow
    private Camera f_109054_;

    @WrapOperation(method={"pick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ProjectileUtil;getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;")})
    private EntityHitResult wrapEntityHit(Entity receiver, Vec3 pickFrom, Vec3 pickTo, AABB aabb, Predicate<Entity> predicate, double pickRangeSqr, Operation<EntityHitResult> original) {
        if (ThirdPerson.isAvailable() && ThirdPersonStatus.isRenderingInThirdPerson() && receiver == this.f_109059_.f_91075_) {
            pickTo = ThirdPerson.CAMERA_AGENT.getHitResult().m_82450_();
            if (ThirdPersonStatus.shouldPickFromCamera()) {
                pickFrom = this.f_109054_.m_90583_();
                Vec3 pickVector = pickFrom.m_82505_(pickTo).m_82541_().m_82490_(1.0E-4);
                pickTo = pickTo.m_82549_(pickVector);
            } else {
                double pickRange = Math.sqrt(pickRangeSqr);
                Vec3 pickVector = pickFrom.m_82505_(pickTo).m_82541_().m_82490_(pickRange);
                pickTo = pickFrom.m_82549_(pickVector);
            }
            aabb = new AABB(pickFrom, pickTo).m_82400_(1.0);
            pickRangeSqr = pickFrom.m_82557_(pickTo);
        }
        return (EntityHitResult)original.call(new Object[]{receiver, pickFrom, pickTo, aabb, predicate, pickRangeSqr});
    }

    @ModifyReturnValue(method={"getFov"}, at={@At(value="RETURN", ordinal=1)})
    private double modifyFov(double fov) {
        if (!((GameRenderer)this).m_172715_() && ThirdPerson.isAvailable() && ThirdPersonStatus.isRenderingInThirdPerson()) {
            fov /= ThirdPerson.CAMERA_AGENT.getSmoothFovDivisor();
        }
        return fov;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void preRender(float partialTick, long nanoTime, boolean doRenderLevel, CallbackInfo ci) {
        if (GameEvents.renderTickStart != null) {
            GameEvents.renderTickStart.accept(new RenderTickStartEvent(partialTick));
        }
    }

    @Inject(method={"bobView"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelBobView(PoseStack poseStack, float partialTick, CallbackInfo ci) {
        if (ThirdPerson.isAvailable() && ThirdPersonStatus.isRenderingInThirdPerson() && ThirdPerson.getConfig().disable_third_person_bob_view) {
            ci.cancel();
        }
    }
}

