/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.mixin;

import com.github.leawind.api.base.GameEvents;
import com.github.leawind.api.client.event.EntityTurnStartEvent;
import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonStatus;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class}, priority=2000)
public class EntityMixin {
    @WrapOperation(method={"pick"}, at={@At(value="NEW", target="Lnet/minecraft/world/level/ClipContext;")})
    private ClipContext wrapPick(Vec3 pickFrom, Vec3 pickTo, ClipContext.Block blockShape, ClipContext.Fluid fluidShape, Entity entity, Operation<ClipContext> original, @Local(argsOnly=true) double pickRange, @Local(argsOnly=true) float partialTick) {
        if (ThirdPerson.isAvailable() && ThirdPersonStatus.isRenderingInThirdPerson() && entity == ThirdPerson.ENTITY_AGENT.getRawCameraEntity()) {
            pickTo = ThirdPerson.CAMERA_AGENT.getHitResult().m_82450_();
            if (ThirdPersonStatus.shouldPickFromCamera()) {
                if (pickFrom.m_82554_(pickTo) > pickRange) {
                    pickTo = pickFrom;
                } else {
                    pickFrom = ThirdPerson.CAMERA_AGENT.getRawCamera().m_90583_();
                    Vec3 pickVector = pickFrom.m_82505_(pickTo).m_82541_();
                    pickTo = pickTo.m_82549_(pickVector.m_82490_(1.0E-4));
                }
            } else {
                Vec3 pickVector = pickFrom.m_82505_(pickTo).m_82541_().m_82490_(pickRange);
                pickTo = pickFrom.m_82549_(pickVector);
            }
        }
        return (ClipContext)original.call(new Object[]{pickFrom, pickTo, blockShape, fluidShape, entity});
    }

    @Inject(method={"turn"}, at={@At(value="HEAD")}, cancellable=true)
    private void preTurn(double yRot, double xRot, @NotNull CallbackInfo ci) {
        if (GameEvents.entityTurnStart != null) {
            Entity entity = (Entity)this;
            EntityTurnStartEvent event = new EntityTurnStartEvent(entity, yRot * 0.15, xRot * 0.15);
            GameEvents.entityTurnStart.accept(event);
            if (event.isDefaultCancelled()) {
                ci.cancel();
            }
        }
    }
}

