/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.core.rotation;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonStatus;
import com.github.leawind.thirdperson.config.AbstractConfig;
import com.github.leawind.thirdperson.core.rotation.RotateTargetEnum;
import com.github.leawind.thirdperson.core.rotation.SmoothTypeEnum;
import com.github.leawind.util.math.decisionmap.DecisionMap;
import com.github.leawind.util.math.decisionmap.DecisionMapBuilder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;

public final class RotateStrategy {
    public static DecisionMap<Double> build() {
        DecisionMapBuilder<Double> builder = DecisionMap.builder();
        builder.factor("aiming", Factor::isAiming);
        builder.factor("swimming", Factor::isSwimming);
        builder.factor("sprint", Factor::wantToSprint);
        builder.factor("fall_flying", Factor::isFallFlying);
        builder.factor("interacting", Factor::shouldTurnToInteractPoint);
        builder.factor("force_rotate", Factor::forceRotate);
        builder.factor("is_passenger", Factor::isPassenger);
        builder.factor("is_vehicle_living_entity", Factor::isVehicleLivingEntity);
        builder.whenDefault(Do::defaultOperation);
        builder.when(List.of("is_passenger", "~is_vehicle_living_entity"), Do::ridingNonLivingEntity);
        builder.when(List.of("is_passenger", "is_vehicle_living_entity"), Do::ridingLivingEntity);
        builder.when("sprint", Do::sprint);
        builder.when("swimming", Do::swimming);
        builder.when("interacting", Do::interacting);
        builder.when("fall_flying", Do::fallFlying);
        builder.when("force_rotate", Do::defaultOperation);
        builder.when("aiming", Do::aiming);
        return builder.build();
    }

    private static final class Do {
        private Do() {
        }

        static double defaultOperation() {
            double rotateHalflife = 0.0;
            switch (ThirdPerson.getConfig().normal_rotate_mode) {
                case INTEREST_POINT: {
                    if (ThirdPersonStatus.impulseHorizon.length() < 1.0E-5) {
                        ThirdPerson.ENTITY_AGENT.setRotateTarget(RotateTargetEnum.INTEREST_POINT);
                    } else {
                        ThirdPerson.ENTITY_AGENT.setRotateTarget(RotateTargetEnum.HORIZONTAL_IMPULSE_DIRECTION);
                    }
                    ThirdPerson.ENTITY_AGENT.setRotationSmoothType(SmoothTypeEnum.EXP_LINEAR);
                    rotateHalflife = 0.06;
                    break;
                }
                case CAMERA_CROSSHAIR: {
                    ThirdPerson.ENTITY_AGENT.setRotateTarget(RotateTargetEnum.CAMERA_HIT_RESULT);
                    ThirdPerson.ENTITY_AGENT.setRotationSmoothType(SmoothTypeEnum.HARD);
                    break;
                }
                case PARALLEL_WITH_CAMERA: {
                    ThirdPerson.ENTITY_AGENT.setRotateTarget(RotateTargetEnum.CAMERA_ROTATION);
                    ThirdPerson.ENTITY_AGENT.setRotationSmoothType(SmoothTypeEnum.LINEAR);
                    break;
                }
                case NONE: {
                    ThirdPerson.ENTITY_AGENT.setRotateTarget(RotateTargetEnum.NONE);
                    ThirdPerson.ENTITY_AGENT.setRotationSmoothType(SmoothTypeEnum.LINEAR);
                }
            }
            return rotateHalflife;
        }

        static double ridingNonLivingEntity() {
            ThirdPerson.ENTITY_AGENT.setRotateTarget(RotateTargetEnum.INTEREST_POINT);
            ThirdPerson.ENTITY_AGENT.setRotationSmoothType(SmoothTypeEnum.EXP_LINEAR);
            return 0.15;
        }

        static double ridingLivingEntity() {
            ThirdPerson.ENTITY_AGENT.setRotateTarget(RotateTargetEnum.HORIZONTAL_IMPULSE_DIRECTION);
            ThirdPerson.ENTITY_AGENT.setRotationSmoothType(SmoothTypeEnum.EXP);
            return 0.1;
        }

        static double sprint() {
            ThirdPerson.ENTITY_AGENT.setRotateTarget(RotateTargetEnum.HORIZONTAL_IMPULSE_DIRECTION);
            ThirdPerson.ENTITY_AGENT.setRotationSmoothType(SmoothTypeEnum.LINEAR);
            return 0.04;
        }

        static double swimming() {
            ThirdPerson.ENTITY_AGENT.setRotateTarget(RotateTargetEnum.IMPULSE_DIRECTION);
            ThirdPerson.ENTITY_AGENT.setRotationSmoothType(SmoothTypeEnum.LINEAR);
            return 0.01;
        }

        static double aiming() {
            ThirdPerson.ENTITY_AGENT.setRotateTarget(RotateTargetEnum.PREDICTED_TARGET_ENTITY);
            ThirdPerson.ENTITY_AGENT.setRotationSmoothType(SmoothTypeEnum.HARD);
            return 0.0;
        }

        static double fallFlying() {
            ThirdPerson.ENTITY_AGENT.setRotateTarget(RotateTargetEnum.CAMERA_ROTATION);
            ThirdPerson.ENTITY_AGENT.setRotationSmoothType(SmoothTypeEnum.HARD);
            return 0.0;
        }

        static double interacting() {
            ThirdPerson.ENTITY_AGENT.setRotateTarget(RotateTargetEnum.CAMERA_HIT_RESULT);
            ThirdPerson.ENTITY_AGENT.setRotationSmoothType(SmoothTypeEnum.LINEAR);
            return 0.0;
        }
    }

    private static final class Factor {
        private Factor() {
        }

        static boolean isSwimming() {
            return ThirdPerson.ENTITY_AGENT.getRawCameraEntity().m_6069_();
        }

        static boolean isAiming() {
            return ThirdPerson.ENTITY_AGENT.isAiming();
        }

        static boolean isFallFlying() {
            return ThirdPerson.ENTITY_AGENT.isFallFlying();
        }

        static boolean shouldTurnToInteractPoint() {
            return ThirdPerson.getConfig().auto_rotate_interacting && ThirdPerson.ENTITY_AGENT.isInteracting() && (!ThirdPerson.getConfig().do_not_rotate_when_eating || !ThirdPerson.ENTITY_AGENT.isEating());
        }

        static boolean wantToSprint() {
            return Minecraft.m_91087_().f_91066_.f_92091_.m_90857_() || ThirdPerson.ENTITY_AGENT.isSprinting();
        }

        static boolean isPassenger() {
            return ThirdPerson.ENTITY_AGENT.getRawCameraEntity().m_20159_();
        }

        static boolean isVehicleLivingEntity() {
            return ThirdPerson.ENTITY_AGENT.getRawCameraEntity().m_20202_() instanceof LivingEntity;
        }

        static boolean forceRotate() {
            return ThirdPerson.getConfig().normal_rotate_mode != AbstractConfig.PlayerRotateMode.INTEREST_POINT;
        }
    }
}

