/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.core;

import com.github.leawind.api.base.GameStatus;
import com.github.leawind.api.client.event.ThirdPersonCameraSetupEvent;
import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonConstants;
import com.github.leawind.thirdperson.ThirdPersonStatus;
import com.github.leawind.thirdperson.cameraoffset.AbstractCameraOffsetMode;
import com.github.leawind.thirdperson.config.AbstractConfig;
import com.github.leawind.thirdperson.config.Config;
import com.github.leawind.thirdperson.core.AimingTargetComparator;
import com.github.leawind.thirdperson.mixin.CameraInvoker;
import com.github.leawind.thirdperson.mixin.ClientLevelInvoker;
import com.github.leawind.thirdperson.mixin.GameRendererInvoker;
import com.github.leawind.util.FiniteChecker;
import com.github.leawind.util.Zone;
import com.github.leawind.util.math.LMath;
import com.github.leawind.util.math.smoothvalue.ExpSmoothDouble;
import com.github.leawind.util.math.smoothvalue.ExpSmoothVector2d;
import com.github.leawind.util.math.smoothvalue.ExpSmoothVector3d;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class CameraAgent {
    public final FiniteChecker FINITE_CHECKER = new FiniteChecker(err -> ThirdPerson.LOGGER.error(err.toString()));
    @NotNull
    private final Minecraft minecraft;
    @NotNull
    private final ExpSmoothVector3d smoothRotateCenter;
    @NotNull
    private final Camera tempCamera = new Camera();
    @NotNull
    private final Vector2d relativeRotation = new Vector2d(0.0);
    @NotNull
    private final ExpSmoothVector2d smoothOffsetRatio;
    @NotNull
    private final ExpSmoothDouble smoothDistance;
    @NotNull
    private final ExpSmoothDouble smoothFovDivisor;
    @NotNull
    private HitResult hitResult = BlockHitResult.m_82426_((Vec3)Vec3.f_82478_, (Direction)Direction.EAST, (BlockPos)BlockPos.f_121853_);

    public CameraAgent(@NotNull Minecraft minecraft) {
        this.minecraft = minecraft;
        this.smoothRotateCenter = new ExpSmoothVector3d();
        this.smoothOffsetRatio = new ExpSmoothVector2d();
        this.smoothDistance = new ExpSmoothDouble();
        this.smoothFovDivisor = new ExpSmoothDouble();
        this.smoothFovDivisor.set(1.0);
    }

    public void reset() {
        ThirdPerson.LOGGER.debug("Reset CameraAgent");
        this.smoothOffsetRatio.setValue(0.0, 0.0);
        this.smoothDistance.set(0.0);
        this.smoothFovDivisor.set(1.0);
        if (ThirdPerson.ENTITY_AGENT.isCameraEntityExist()) {
            this.smoothRotateCenter.set(this.getRotateCenterTarget(1.0f));
            Entity entity = ThirdPerson.ENTITY_AGENT.getRawCameraEntity();
            this.relativeRotation.set((double)(-entity.m_146909_()), (double)(entity.m_146908_() - 180.0f));
        }
    }

    public void checkGameStatus() {
        if (this.minecraft.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            GameStatus.isPerspectiveInverted = (Double)this.smoothDistance.get() > 0.05;
        }
    }

    public void onRenderTickStart(double now, double period, float partialTick) {
        if (!this.minecraft.m_91104_() && ThirdPersonStatus.isRenderingInThirdPerson()) {
            this.hitResult = this.pick(this.getPickRange());
            this.updateSmoothVirtualDistance(period);
            this.updateSmoothOffsetRatio(period);
            this.updateSmoothFovMultiplier(period);
            if (ThirdPersonStatus.shouldCameraTurnWithEntity()) {
                Vector2d rot = ThirdPerson.ENTITY_AGENT.getRawRotation(partialTick);
                this.FINITE_CHECKER.checkOnce(rot.x, rot.y);
                this.relativeRotation.set(-rot.x, rot.y - 180.0);
            }
        }
    }

    public double getSmoothFovDivisor() {
        return (Double)this.smoothFovDivisor.get();
    }

    public void onCameraSetup(@NotNull ThirdPersonCameraSetupEvent event) {
        this.updateTempCameraRotationPosition(event.partialTick);
        event.setPosition(this.tempCamera.m_90583_());
        float yRot = this.tempCamera.m_90590_();
        float xRot = this.tempCamera.m_90589_();
        this.FINITE_CHECKER.checkOnce(Float.valueOf(xRot), Float.valueOf(yRot));
        event.setRotation(xRot, yRot);
    }

    public Vector3d getRotateCenterTarget(float partialTick) {
        Config config = ThirdPerson.getConfig();
        Entity entity = ThirdPerson.ENTITY_AGENT.getRawCameraEntity();
        Vec3 eyePosition = entity.m_20299_(partialTick);
        return LMath.toVector3d(eyePosition.m_193103_(Direction.Axis.Y, eyePosition.f_82480_ + config.rotate_center_height_offset));
    }

    public boolean limitRotateCenter(Vector3d rotateCenter, float partialTick) {
        Entity entity = ThirdPerson.ENTITY_AGENT.getRawCameraEntity();
        Vec3 smoothEyePosition = LMath.toVec3(this.smoothRotateCenter.get(partialTick));
        Vec3 eyePosition = new Vec3(smoothEyePosition.f_82479_, entity.m_20299_((float)partialTick).f_82480_, smoothEyePosition.f_82481_);
        Zone limit = Zone.ofAuto(eyePosition.f_82480_, rotateCenter.y).expendRadius(0.5);
        Vec3 pickEnd = new Vec3(eyePosition.f_82479_, limit.max, eyePosition.f_82481_);
        BlockHitResult hitResult = entity.m_9236_().m_45547_(new ClipContext(eyePosition, pickEnd, ThirdPersonConstants.CAMERA_OBSTACLE_BLOCK_SHAPE_GETTER, ClipContext.Fluid.NONE, entity));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            limit = limit.withMax(hitResult.m_82450_().f_82480_);
        }
        pickEnd = new Vec3(eyePosition.f_82479_, limit.min, eyePosition.f_82481_);
        hitResult = entity.m_9236_().m_45547_(new ClipContext(eyePosition, pickEnd, ThirdPersonConstants.CAMERA_OBSTACLE_BLOCK_SHAPE_GETTER, ClipContext.Fluid.NONE, entity));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            limit = limit.withMin(hitResult.m_82450_().f_82480_);
        }
        for (int i = 0; i < 4; ++i) {
            double offsetX = 0.3 * (double)((i & 1) * 2 - 1);
            double offsetZ = 0.3 * (double)((i >> 1 & 1) * 2 - 1);
            pickEnd = new Vec3(eyePosition.f_82479_ + offsetX, limit.max, eyePosition.f_82481_ + offsetZ);
            hitResult = entity.m_9236_().m_45547_(new ClipContext(eyePosition, pickEnd, ThirdPersonConstants.CAMERA_OBSTACLE_BLOCK_SHAPE_GETTER, ClipContext.Fluid.NONE, entity));
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                limit = limit.withMax(hitResult.m_82450_().f_82480_);
            }
            pickEnd = new Vec3(eyePosition.f_82479_ + offsetX, limit.min, eyePosition.f_82481_ + offsetZ);
            hitResult = entity.m_9236_().m_45547_(new ClipContext(eyePosition, pickEnd, ThirdPersonConstants.CAMERA_OBSTACLE_BLOCK_SHAPE_GETTER, ClipContext.Fluid.NONE, entity));
            if (hitResult.m_6662_() != HitResult.Type.BLOCK) continue;
            limit = limit.withMin(hitResult.m_82450_().f_82480_);
        }
        double newY = (limit = limit.squeezeSafely(0.5)).nearest(rotateCenter.y);
        boolean result = newY != rotateCenter.y;
        rotateCenter.y = newY;
        return result;
    }

    @NotNull
    public Vector3d getRotateCenterFinally(float partialTick) {
        boolean isVerticalZero;
        Vector3d rotateCenter = this.smoothRotateCenter.get(partialTick);
        Vector3d smoothFactor = (Vector3d)this.smoothRotateCenter.smoothFactor;
        boolean isHorizontalZero = smoothFactor.x * smoothFactor.z == 0.0;
        boolean bl = isVerticalZero = smoothFactor.y == 0.0;
        if (isHorizontalZero || isVerticalZero) {
            Vector3d rotateCenterTarget = this.getRotateCenterTarget(partialTick);
            rotateCenter = new Vector3d(isHorizontalZero ? rotateCenterTarget.x : rotateCenter.x, isVerticalZero ? rotateCenterTarget.y : rotateCenter.y, isHorizontalZero ? rotateCenterTarget.z : rotateCenter.z);
        }
        if (this.limitRotateCenter(rotateCenter, partialTick)) {
            ((Vector3d)this.smoothRotateCenter.target).y = rotateCenter.y;
        }
        return rotateCenter;
    }

    public void onClientTickStart() {
        Config config = ThirdPerson.getConfig();
        Vector3d halflife = this.minecraft.f_91066_.m_92176_() == CameraType.FIRST_PERSON ? new Vector3d(0.0) : (ThirdPerson.ENTITY_AGENT.isFallFlying() ? new Vector3d(config.flying_smooth_halflife) : config.getCameraOffsetScheme().getMode().getEyeSmoothHalflife());
        double dist = this.getRotateCenterFinally(1.0f).distance((Vector3dc)ThirdPerson.CAMERA_AGENT.getRawCameraPosition());
        halflife.mul(Math.pow(dist, 0.5) * 0.1);
        this.smoothRotateCenter.setHalflife(halflife);
        this.smoothRotateCenter.setTarget(this.getRotateCenterTarget(1.0f));
        this.smoothRotateCenter.update(0.05);
    }

    @NotNull
    public Camera getRawCamera() {
        return Objects.requireNonNull(Minecraft.m_91087_().f_91063_.m_109153_());
    }

    @NotNull
    public Vector3d getRawCameraPosition() {
        return LMath.toVector3d(this.getRawCamera().m_90583_());
    }

    @NotNull
    public Vector2d getRotation() {
        return new Vector2d(-this.relativeRotation.x, this.relativeRotation.y % 360.0 - 180.0);
    }

    public void setRotation(Vector2d rot) {
        this.relativeRotation.x = -rot.x;
        this.relativeRotation.y = rot.y % 360.0 - 180.0;
    }

    public Vector2d getRawRotation() {
        Camera camera = ThirdPerson.CAMERA_AGENT.getRawCamera();
        return new Vector2d((double)camera.m_90589_(), (double)camera.m_90590_());
    }

    public void turnCamera(double dYRot, double dXRot) {
        this.FINITE_CHECKER.checkOnce(dYRot, dXRot);
        Config config = ThirdPerson.getConfig();
        if (config.is_mod_enabled && !ThirdPersonStatus.isAdjustingCameraOffset() && (dYRot != 0.0 || dXRot != 0.0)) {
            double xRot;
            double yRot = this.getRelativeRotation().y + dYRot;
            yRot %= 360.0;
            if (config.lock_camera_pitch_angle) {
                xRot = 0.0;
            } else {
                xRot = this.getRelativeRotation().x - dXRot;
                xRot = LMath.clamp(xRot, -89.8, 89.8);
            }
            this.relativeRotation.set(xRot, yRot);
        }
    }

    @NotNull
    public Vector2d getRelativeRotation() {
        return this.relativeRotation;
    }

    @NotNull
    public HitResult getHitResult() {
        return this.hitResult;
    }

    public double getPickRange() {
        return ThirdPerson.ENTITY_AGENT.getBodyRadius() + (Double)this.smoothDistance.get() + ThirdPerson.getConfig().camera_ray_trace_length;
    }

    @NotNull
    public HitResult pick(double pickRange) {
        EntityHitResult entityHitResult = this.pickEntity(pickRange);
        BlockHitResult blockHitResult = this.pickBlock(pickRange);
        if (entityHitResult != null) {
            Vec3 cameraPos = this.getRawCamera().m_90583_();
            double blockDistance = cameraPos.m_82554_(blockHitResult.m_82450_());
            double entityDistance = cameraPos.m_82554_(entityHitResult.m_82450_());
            if (entityDistance < blockDistance) {
                return entityHitResult;
            }
        }
        return blockHitResult;
    }

    @Nullable
    public EntityHitResult pickEntity(double pickRange) {
        if (!ThirdPerson.ENTITY_AGENT.isCameraEntityExist()) {
            return null;
        }
        Entity cameraEntity = ThirdPerson.ENTITY_AGENT.getRawCameraEntity();
        Camera camera = this.getRawCamera();
        Vec3 viewVector = new Vec3(camera.m_253058_());
        Vec3 pickFrom = camera.m_90583_();
        Vec3 pickTo = viewVector.m_82490_(pickRange).m_82549_(pickFrom);
        AABB aabb = new AABB(pickFrom, pickTo);
        return ProjectileUtil.m_37287_((Entity)cameraEntity, (Vec3)pickFrom, (Vec3)pickTo, (AABB)aabb, target -> !target.m_5833_() && target.m_6087_(), (double)pickRange);
    }

    @NotNull
    public BlockHitResult pickBlock(double pickRange, @NotNull ClipContext.Block blockShape, @NotNull ClipContext.Fluid fluidShape) {
        Camera camera = this.getRawCamera();
        Vec3 pickFrom = camera.m_90583_();
        Vec3 viewVector = new Vec3(camera.m_253058_());
        Vec3 pickTo = pickFrom.m_82549_(viewVector.m_82490_(pickRange));
        Entity cameraEntity = ThirdPerson.ENTITY_AGENT.getRawCameraEntity();
        return cameraEntity.m_9236_().m_45547_(new ClipContext(pickFrom, pickTo, blockShape, fluidShape, cameraEntity));
    }

    @NotNull
    public BlockHitResult pickBlock(double pickRange) {
        return this.pickBlock(pickRange, ThirdPerson.ENTITY_AGENT.wasAiming() ? ClipContext.Block.COLLIDER : ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE);
    }

    public boolean isLookingAt(@NotNull Entity entity) {
        Vec3 from = this.getRawCamera().m_90583_();
        Vec3 to = from.m_82549_(new Vec3(this.getRawCamera().m_253058_()).m_82490_(this.getPickRange()));
        AABB aabb = entity.m_20191_();
        return aabb.m_82390_(from) || aabb.m_82371_(from, to).isPresent();
    }

    @Nullable
    public Entity predictTargetEntity(float partialTick) {
        Config config = ThirdPerson.getConfig();
        ArrayList candidateTargets = Lists.newArrayList();
        Vec3 cameraPos = this.getRawCamera().m_90583_();
        Vector2d cameraRot = this.getRotation();
        Vector3d cameraViewVector = LMath.directionFromRotationDegree(cameraRot).normalize();
        if (ThirdPerson.ENTITY_AGENT.isControlled()) {
            LocalPlayer playerEntity = ThirdPerson.ENTITY_AGENT.getRawPlayerEntity();
            ClientLevel clientLevel = (ClientLevel)playerEntity.m_9236_();
            LevelEntityGetter<Entity> entityGetter = ((ClientLevelInvoker)clientLevel).invokeGetEntityGetter();
            for (Entity target : entityGetter.m_142273_()) {
                double distance;
                if (!(target instanceof LivingEntity) || (distance = (double)target.m_20270_((Entity)playerEntity)) < 2.0 || distance > config.camera_ray_trace_length || target.m_7306_((Entity)playerEntity)) continue;
                Vec3 targetPos = target.m_20318_(partialTick);
                Vector3d bottomY = LMath.toVector3d(targetPos.m_193103_(Direction.Axis.Y, target.m_20191_().f_82289_));
                Vector3d vectorToBottom = new Vector3d((Vector3dc)bottomY).sub((Vector3dc)ThirdPerson.ENTITY_AGENT.getRawEyePosition(partialTick));
                if (LMath.rotationDegreeFromDirection((Vector3d)vectorToBottom).x < cameraRot.x) continue;
                Vector3d vectorToTarget = LMath.toVector3d(targetPos.m_82546_(cameraPos)).normalize();
                FiniteChecker.assertFinite(vectorToTarget.x, vectorToTarget.y, vectorToTarget.z);
                double angrad = Math.acos(cameraViewVector.dot((Vector3dc)vectorToTarget));
                if (!(Math.toDegrees(angrad) < 30.0)) continue;
                candidateTargets.add(target);
            }
        }
        if (!candidateTargets.isEmpty()) {
            candidateTargets.sort(new AimingTargetComparator(cameraPos, cameraViewVector));
            return (Entity)candidateTargets.get(0);
        }
        return null;
    }

    private void updateTempCameraRotationPosition(float partialTick) {
        ((CameraInvoker)this.tempCamera).invokeSetRotation((float)(this.relativeRotation.y + 180.0), (float)(-this.relativeRotation.x));
        Minecraft minecraft = Minecraft.m_91087_();
        AbstractConfig.CameraDistanceMode cameraDistanceMode = ThirdPerson.getConfig().camera_distance_mode;
        double aspectRatio = (double)minecraft.m_91268_().m_85441_() / (double)minecraft.m_91268_().m_85442_();
        double fov = ((GameRendererInvoker)minecraft.f_91063_).invokeGetFov(this.getRawCamera(), partialTick, true);
        double verticalRadianHalf = Math.toRadians(fov) / 2.0;
        double heightHalf = Math.tan(verticalRadianHalf) * 0.05;
        double widthHalf = aspectRatio * heightHalf;
        Vector3d forward = LMath.toVector3d(this.tempCamera.m_253058_());
        Vector3d left = LMath.toVector3d(this.tempCamera.m_252775_());
        Vector3d up = LMath.toVector3d(this.tempCamera.m_253028_());
        double verticalFovHalf = Math.toRadians(fov);
        double horizontalFovHalf = 2.0 * Math.atan(widthHalf / 0.05);
        Vector2d offsetRatio = (Vector2d)this.smoothOffsetRatio.get();
        double offsetX = offsetRatio.x;
        double offsetY = offsetRatio.y;
        Vector3d direction = forward.sub((Vector3dc)up.mul(offsetY * Math.tan(verticalFovHalf / 2.0)).add((Vector3dc)left.mul(offsetX * Math.tan(horizontalFovHalf / 2.0))));
        if (cameraDistanceMode == AbstractConfig.CameraDistanceMode.STRAIGHT) {
            direction.normalize();
            FiniteChecker.assertFinite(direction.x, direction.y, direction.z);
        }
        Vector3d rotateCenterVector3d = this.getRotateCenterFinally(partialTick);
        double bodyRadius = ThirdPerson.ENTITY_AGENT.getBodyRadius();
        Vec3 cameraPosition = LMath.toVec3(rotateCenterVector3d.sub((Vector3dc)direction.mul(bodyRadius + (Double)this.smoothDistance.get())));
        ((CameraInvoker)this.tempCamera).invokeSetPosition(cameraPosition);
        Vec3 rotateCenter = LMath.toVec3(this.getRotateCenterFinally(partialTick));
        Entity entity = ThirdPerson.ENTITY_AGENT.getRawCameraEntity();
        if (entity.m_5833_() && ThirdPerson.ENTITY_AGENT.isEyeInWall((ClipContext.ShapeGetter)ClipContext.Block.VISUAL)) {
            return;
        }
        Vec3 rotateCenterToCamera = rotateCenter.m_82505_(cameraPosition);
        double initDistance = rotateCenterToCamera.m_82553_();
        if (initDistance < 1.0E-5) {
            return;
        }
        double limit = initDistance;
        for (int i = 0; i < 8; ++i) {
            double offsetX2 = 0.18 * (double)((i & 1) * 2 - 1);
            double offsetY2 = 0.18 * (double)((i >> 1 & 1) * 2 - 1);
            double offsetZ = 0.18 * (double)((i >> 2 & 1) * 2 - 1);
            Vec3 pickFrom = rotateCenter.m_82520_(offsetX2, offsetY2, offsetZ);
            Vec3 pickTo = pickFrom.m_82549_(rotateCenterToCamera);
            BlockHitResult hitResult = entity.m_9236_().m_45547_(new ClipContext(pickFrom, pickTo, ThirdPersonConstants.CAMERA_OBSTACLE_BLOCK_SHAPE_GETTER, ClipContext.Fluid.NONE, ThirdPerson.ENTITY_AGENT.getRawCameraEntity()));
            if (hitResult.m_6662_() == HitResult.Type.MISS) continue;
            limit = Math.min(limit, hitResult.m_82450_().m_82554_(pickFrom));
        }
        if (limit < initDistance) {
            switch (cameraDistanceMode) {
                case PLANE: {
                    this.smoothDistance.setValue(Math.max(0.0, (Double)this.smoothDistance.get() + limit - initDistance));
                    break;
                }
                case STRAIGHT: {
                    this.smoothDistance.setValue(Math.max(0.0, limit - bodyRadius));
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid camera distance mode: " + cameraDistanceMode);
                }
            }
            Vec3 limitedPosition = rotateCenter.m_82549_(rotateCenterToCamera.m_82490_(limit / initDistance));
            ((CameraInvoker)this.tempCamera).invokeSetPosition(limitedPosition);
        }
    }

    private void updateSmoothVirtualDistance(double period) {
        Config config = ThirdPerson.getConfig();
        AbstractCameraOffsetMode mode = config.getCameraOffsetScheme().getMode();
        boolean isAdjusting = ThirdPersonStatus.isAdjustingCameraDistance();
        double BODY_RADIUS = ThirdPerson.ENTITY_AGENT.getBodyRadius();
        if (this.minecraft.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            this.smoothDistance.setHalflife(config.t2f_transition_halflife);
            this.smoothDistance.setTarget(-BODY_RADIUS * 0.5);
        } else {
            this.smoothDistance.setHalflife(isAdjusting ? config.adjusting_distance_smooth_halflife : mode.getDistanceSmoothHalflife());
            this.smoothDistance.setTarget((mode.getDistanceLimit() * ThirdPerson.ENTITY_AGENT.vehicleTotalSizeCached + BODY_RADIUS) * this.getSmoothFovDivisor() - BODY_RADIUS);
        }
        this.smoothDistance.update(period);
        this.FINITE_CHECKER.checkOnce(this.smoothDistance.get());
    }

    private void updateSmoothOffsetRatio(double period) {
        Config config = ThirdPerson.getConfig();
        AbstractCameraOffsetMode mode = config.getCameraOffsetScheme().getMode();
        if (ThirdPersonStatus.isAdjustingCameraOffset()) {
            this.smoothOffsetRatio.setHalflife(config.adjusting_camera_offset_smooth_halflife);
        } else {
            this.smoothOffsetRatio.setHalflife(mode.getOffsetSmoothHalflife());
        }
        if (config.center_offset_when_flying && ThirdPerson.ENTITY_AGENT.isFallFlying()) {
            this.smoothOffsetRatio.setTarget(0.0, 0.0);
        } else {
            mode.getOffsetRatio((Vector2d)this.smoothOffsetRatio.target);
        }
        this.smoothOffsetRatio.update(period);
    }

    private void updateSmoothFovMultiplier(double period) {
        Config config = ThirdPerson.getConfig();
        this.smoothFovDivisor.setHalflife(config.getCameraOffsetScheme().getMode().getDistanceSmoothHalflife());
        this.smoothFovDivisor.setTarget(ThirdPerson.ENTITY_AGENT.wasAiming() ? config.aiming_fov_divisor : 1.0);
        this.smoothFovDivisor.update(period);
    }
}

