/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.core;

import com.github.leawind.util.math.LMath;
import java.util.Comparator;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public record AimingTargetComparator(Vec3 pos, Vector3d viewVector) implements Comparator<Entity>
{
    @Override
    public int compare(Entity e1, Entity e2) {
        return (int)Math.signum(this.getCost(e1) - this.getCost(e2));
    }

    public double getCost(@NotNull Entity entity) {
        Vec3 entityPos = entity.m_20318_(1.0f);
        Vector3d vectorToTarget = LMath.toVector3d(entityPos.m_82546_(this.pos));
        if (vectorToTarget.length() < 1.0E-5) {
            return 0.0;
        }
        vectorToTarget.normalize();
        double dist = this.pos.m_82554_(entityPos);
        double angrad = Math.acos(this.viewVector.dot((Vector3dc)vectorToTarget));
        double angdeg = Math.toDegrees(angrad);
        return Math.pow(dist, 2.0) * Math.pow(angdeg, 2.5);
    }
}

