/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.config;

import com.github.leawind.thirdperson.config.ConfigManager;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;

public abstract class AbstractConfig {
    @Expose
    public boolean is_mod_enabled = true;
    @Expose
    public boolean center_offset_when_flying = true;
    @Expose
    public boolean temp_first_person_in_narrow_space = true;
    @Expose
    public PlayerRotateMode normal_rotate_mode = PlayerRotateMode.INTEREST_POINT;
    @Expose
    public boolean auto_rotate_interacting = true;
    @Expose
    public boolean do_not_rotate_when_eating = true;
    @Expose
    public boolean auto_turn_body_drawing_a_bow = false;
    @Expose
    public boolean player_fade_out_enabled = false;
    @Expose
    public double gaze_opacity = 0.28;
    @Expose
    public double player_invisible_threshold = 0.55;
    @Expose
    public int available_distance_count = 16;
    @Expose
    public double camera_distance_min = 0.0;
    @Expose
    public double camera_distance_max = 4.0;
    @Expose
    public double flying_smooth_halflife = 0.45;
    @Expose
    public double t2f_transition_halflife = 0.1;
    @Expose
    public double adjusting_camera_offset_smooth_halflife = 0.04;
    @Expose
    public double adjusting_distance_smooth_halflife = 0.08;
    @Expose
    public double normal_smooth_halflife_horizon = 0.25;
    @Expose
    public double normal_smooth_halflife_vertical = 0.2;
    @Expose
    public double normal_camera_offset_smooth_halflife = 0.08;
    @Expose
    public double normal_distance_smooth_halflife = 0.72;
    @Expose
    public double aiming_smooth_halflife_horizon = 0.05;
    @Expose
    public double aiming_smooth_halflife_vertical = 0.05;
    @Expose
    public double aiming_camera_offset_smooth_halflife = 0.03;
    @Expose
    public double aiming_distance_smooth_halflife = 0.04;
    @Expose
    public double aiming_fov_divisor = 1.125;
    @Expose
    public double normal_max_distance = 1.5625;
    @Expose
    public double normal_offset_x = -0.145;
    @Expose
    public double normal_offset_y = 0.12;
    @Expose
    public boolean normal_is_centered = false;
    @Expose
    public double normal_offset_center = 0.24;
    @Expose
    public double aiming_max_distance = 0.56;
    @Expose
    public double aiming_offset_x = -0.29;
    @Expose
    public double aiming_offset_y = 0.19;
    @Expose
    public boolean aiming_is_centered = false;
    @Expose
    public double aiming_offset_center = 0.48;
    @Expose
    public boolean determine_aim_mode_by_animation = true;
    @Expose
    public List<String> hold_to_aim_item_patterns = new ArrayList<String>();
    @Expose
    public List<String> use_to_aim_item_patterns = new ArrayList<String>();
    @Expose
    public List<String> use_to_first_person_patterns = new ArrayList<String>();
    @Expose
    public String config_screen_api = "YACL";
    @Expose
    public CameraDistanceMode camera_distance_mode = CameraDistanceMode.STRAIGHT;
    @Expose
    public double rotate_center_height_offset = 0.3;
    @Expose
    public boolean enable_target_entity_predict = true;
    @Expose
    public boolean skip_vanilla_second_person_camera = true;
    @Expose
    public boolean disable_third_person_bob_view = false;
    @Expose
    public boolean allow_double_tap_sprint = false;
    @Expose
    public boolean lock_camera_pitch_angle = false;
    @Expose
    public boolean use_camera_pick_in_creative = false;
    @Expose
    public double camera_ray_trace_length = 512.0;
    @Expose
    public boolean render_crosshair_when_not_aiming = true;
    @Expose
    public boolean render_crosshair_when_aiming = true;
    @Expose
    public boolean hide_crosshair_when_flying = true;

    public static enum PlayerRotateMode {
        INTEREST_POINT("interest_point"),
        CAMERA_CROSSHAIR("camera_crosshair"),
        PARALLEL_WITH_CAMERA("parallel_with_camera"),
        NONE("none");

        public static final String KEY = "option.normal_rotate_mode";
        private final String key;

        public static Component formatter(Enum<PlayerRotateMode> value) {
            return PlayerRotateMode.formatter((PlayerRotateMode)value);
        }

        public static Component formatter(PlayerRotateMode value) {
            return ConfigManager.getText("option.normal_rotate_mode." + value.key);
        }

        private PlayerRotateMode(String key) {
            this.key = key;
        }
    }

    public static enum CameraDistanceMode {
        PLANE(true, "plane"),
        STRAIGHT(false, "straight");

        public static final String KEY = "option.camera_distance_mode";
        private final boolean bool;
        private final String key;

        public static CameraDistanceMode of(boolean b) {
            return b ? PLANE : STRAIGHT;
        }

        public static Component formatter(boolean v) {
            return ConfigManager.getText("option.camera_distance_mode." + CameraDistanceMode.of((boolean)v).key);
        }

        public static Component formatter(Enum<CameraDistanceMode> value) {
            return CameraDistanceMode.formatter((CameraDistanceMode)value);
        }

        public static Component formatter(CameraDistanceMode value) {
            return ConfigManager.getText("option.camera_distance_mode." + value.key);
        }

        private CameraDistanceMode(boolean bool, String key) {
            this.bool = bool;
            this.key = key;
        }

        public boolean bool() {
            return this.bool;
        }
    }
}

