/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.cameraoffset;

import com.github.leawind.thirdperson.cameraoffset.AbstractCameraOffsetMode;
import com.github.leawind.thirdperson.config.Config;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector3d;

public class CameraOffsetModeNormal
extends AbstractCameraOffsetMode {
    public CameraOffsetModeNormal(@NotNull Config config) {
        super(config);
    }

    @Override
    @NotNull
    public Vector3d getEyeSmoothHalflife() {
        return new Vector3d(this.config.normal_smooth_halflife_horizon, this.config.normal_smooth_halflife_vertical, this.config.normal_smooth_halflife_horizon);
    }

    @Override
    public double getDistanceSmoothHalflife() {
        return this.config.normal_distance_smooth_halflife;
    }

    @Override
    @NotNull
    public Vector2d getOffsetSmoothHalflife() {
        return new Vector2d(this.config.normal_camera_offset_smooth_halflife);
    }

    @Override
    public double getDistanceLimit() {
        return this.config.normal_max_distance;
    }

    @Override
    public void setDistanceLimit(double distance) {
        this.config.normal_max_distance = distance;
    }

    @Override
    public boolean isCentered() {
        return this.config.normal_is_centered;
    }

    @Override
    public void setCentered(boolean isCentered) {
        this.config.normal_is_centered = isCentered;
    }

    @Override
    public boolean isCameraLeftOfPlayer() {
        return this.config.normal_offset_x > 0.0;
    }

    @Override
    public void toNextSide() {
        if (this.isCentered()) {
            this.setCentered(false);
        } else {
            this.config.normal_offset_x = -this.config.normal_offset_x;
        }
    }

    @Override
    public void setSideOffsetRatio(@NotNull Vector2d v) {
        this.config.normal_offset_x = v.x;
        this.config.normal_offset_y = v.y;
    }

    @Override
    public double getCenterOffsetRatio() {
        return this.config.normal_offset_center;
    }

    @Override
    public void setCenterOffsetRatio(double offset) {
        this.config.normal_offset_center = offset;
    }

    @Override
    @NotNull
    public Vector2d getSideOffsetRatio(@NotNull Vector2d v) {
        return v.set(this.config.normal_offset_x, this.config.normal_offset_y);
    }
}

