/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson;

import com.github.leawind.api.base.GameEvents;
import com.github.leawind.api.base.GameStatus;
import com.github.leawind.api.client.event.CalculateMoveImpulseEvent;
import com.github.leawind.api.client.event.EntityTurnStartEvent;
import com.github.leawind.api.client.event.MouseTurnPlayerStartEvent;
import com.github.leawind.api.client.event.RenderEntityEvent;
import com.github.leawind.api.client.event.RenderTickStartEvent;
import com.github.leawind.api.client.event.ThirdPersonCameraSetupEvent;
import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonResources;
import com.github.leawind.thirdperson.ThirdPersonStatus;
import com.github.leawind.thirdperson.cameraoffset.AbstractCameraOffsetMode;
import com.github.leawind.thirdperson.cameraoffset.CameraOffsetScheme;
import com.github.leawind.thirdperson.config.Config;
import com.github.leawind.util.ItemPredicateUtil;
import com.github.leawind.util.math.LMath;
import com.mojang.blaze3d.platform.Window;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public final class ThirdPersonEvents {
    public static void register() {
        ClientTickEvent.CLIENT_PRE.register(ThirdPersonEvents::onClientTickPre);
        ClientLifecycleEvent.CLIENT_STOPPING.register(ThirdPersonEvents::onClientStopping);
        ClientPlayerEvent.CLIENT_PLAYER_RESPAWN.register(ThirdPersonEvents::onClientPlayerRespawn);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(ThirdPersonEvents::onClientPlayerJoin);
        ClientRawInputEvent.MOUSE_SCROLLED.register(ThirdPersonEvents::onMouseScrolled);
        GameEvents.thirdPersonCameraSetup = ThirdPersonEvents::onThirdPersonCameraSetup;
        GameEvents.renderTickStart = ThirdPersonEvents::onRenderTickStart;
        GameEvents.calculateMoveImpulse = ThirdPersonEvents::onCalculateMoveImpulse;
        GameEvents.renderEntity = ThirdPersonEvents::onRenderEntity;
        GameEvents.handleKeybindsStart = ThirdPersonEvents::onHandleKeybindsStart;
        GameEvents.mouseTurnPlayerStart = ThirdPersonEvents::onMouseTurnPlayerStart;
        GameEvents.entityTurnStart = ThirdPersonEvents::onEntityTurnStart;
    }

    private static void onClientTickPre(@NotNull Minecraft minecraft) {
        if (minecraft.m_91104_() || !ThirdPerson.isAvailable()) {
            return;
        }
        Config config = ThirdPerson.getConfig();
        if (minecraft.f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            LivingEntity livingEntity;
            Entity cameraEntity = ThirdPerson.ENTITY_AGENT.getRawCameraEntity();
            boolean bl = GameStatus.isPerspectiveInverted = !cameraEntity.m_5833_() && cameraEntity.m_5830_();
            if (cameraEntity instanceof LivingEntity && (livingEntity = (LivingEntity)cameraEntity).m_6117_()) {
                GameStatus.isPerspectiveInverted |= ItemPredicateUtil.anyMatches(livingEntity.m_21211_(), config.getUseToFirstPersonItemPredicates(), ThirdPersonResources.itemPredicateManager.useToFirstPersonItemPredicates);
            }
            ThirdPersonStatus.ticksSinceLeaveNarrowSpace = Math.min(16, ThirdPersonStatus.ticksSinceLeaveNarrowSpace + 1);
            if (config.temp_first_person_in_narrow_space && !cameraEntity.m_5833_()) {
                boolean isInNarrowSpace = ThirdPersonStatus.calcIsInNarrowSpace(cameraEntity);
                if (isInNarrowSpace) {
                    ThirdPersonStatus.ticksSinceLeaveNarrowSpace = 0;
                }
                GameStatus.isPerspectiveInverted |= ThirdPersonStatus.ticksSinceLeaveNarrowSpace < 16;
            }
        }
        ThirdPerson.ENTITY_AGENT.onClientTickStart();
        ThirdPerson.CAMERA_AGENT.onClientTickStart();
    }

    private static void onClientStopping(Minecraft minecraft) {
        ThirdPerson.CONFIG_MANAGER.trySave();
    }

    private static void onClientPlayerRespawn(@NotNull LocalPlayer oldPlayer, @NotNull LocalPlayer newPlayer) {
        if (ThirdPerson.getConfig().is_mod_enabled) {
            ThirdPersonEvents.resetPlayer();
            ThirdPerson.LOGGER.info("on Client player respawn");
        }
    }

    private static void onClientPlayerJoin(@NotNull LocalPlayer player) {
        Config config = ThirdPerson.getConfig();
        if (config.is_mod_enabled) {
            ThirdPersonEvents.resetPlayer();
            ThirdPerson.LOGGER.info("on Client player join");
        }
        config.updateItemPredicates();
        ThirdPersonResources.itemPredicateManager.reparse();
    }

    @NotNull
    private static EventResult onMouseScrolled(@NotNull Minecraft minecraft, double amount) {
        return ThirdPersonEvents.onMouseScrolled(minecraft, 0.0, amount);
    }

    private static void onThirdPersonCameraSetup(ThirdPersonCameraSetupEvent event) {
        if (ThirdPerson.isAvailable() && ThirdPerson.ENTITY_AGENT.isCameraEntityExist() && ThirdPersonStatus.isRenderingInThirdPerson()) {
            ThirdPerson.CAMERA_AGENT.onCameraSetup(event);
        }
    }

    private static void onRenderTickStart(RenderTickStartEvent event) {
        GameStatus.forceThirdPersonCrosshair = ThirdPersonStatus.shouldRenderThirdPersonCrosshair();
        if (!ThirdPerson.getConfig().is_mod_enabled) {
            return;
        }
        ThirdPerson.CAMERA_AGENT.checkGameStatus();
        double now = (double)System.currentTimeMillis() / 1000.0;
        double period = now - ThirdPersonStatus.lastRenderTickTimeStamp;
        ThirdPersonStatus.lastRenderTickTimeStamp = now;
        boolean isRenderingInThirdPerson = ThirdPersonStatus.isRenderingInThirdPerson();
        if (isRenderingInThirdPerson != ThirdPersonStatus.wasRenderInThirdPersonLastRenderTick) {
            if (isRenderingInThirdPerson) {
                ThirdPersonEvents.resetPlayer();
                if (ThirdPersonStatus.isRenderingInThirdPerson()) {
                    Vector2d cameraRot = ThirdPerson.CAMERA_AGENT.getRawRotation();
                    ThirdPerson.ENTITY_AGENT.setRawRotation(cameraRot);
                    ThirdPerson.ENTITY_AGENT.getSmoothRotation().set(cameraRot);
                    ThirdPerson.CAMERA_AGENT.setRotation(cameraRot);
                }
            } else {
                ThirdPerson.ENTITY_AGENT.setRawRotation(ThirdPerson.CAMERA_AGENT.getRotation());
            }
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.f_91063_.m_109106_(minecraft.m_91288_());
            minecraft.f_91060_.m_109826_();
            ThirdPersonStatus.wasRenderInThirdPersonLastRenderTick = isRenderingInThirdPerson;
        }
        if (isRenderingInThirdPerson) {
            boolean shouldCameraTurnWithEntity = ThirdPersonStatus.shouldCameraTurnWithEntity();
            if (shouldCameraTurnWithEntity && !ThirdPersonStatus.wasShouldCameraTurnWithEntity && ThirdPersonStatus.isRenderingInThirdPerson()) {
                ThirdPerson.ENTITY_AGENT.setRawRotation(ThirdPerson.CAMERA_AGENT.getRotation());
            }
            ThirdPersonStatus.wasShouldCameraTurnWithEntity = shouldCameraTurnWithEntity;
        }
        if (ThirdPerson.isAvailable() && ThirdPerson.ENTITY_AGENT.isCameraEntityExist()) {
            ThirdPerson.ENTITY_AGENT.onRenderTickStart(now, period, event.partialTick);
            ThirdPerson.CAMERA_AGENT.onRenderTickStart(now, period, event.partialTick);
        }
    }

    private static void onCalculateMoveImpulse(CalculateMoveImpulseEvent event) {
        if (ThirdPerson.isAvailable() && ThirdPersonStatus.isRenderingInThirdPerson() && ThirdPerson.ENTITY_AGENT.isControlled()) {
            Camera camera = ThirdPerson.CAMERA_AGENT.getRawCamera();
            Vector3d lookImpulse = LMath.toVector3d(camera.m_253058_()).normalize();
            Vector3d leftImpulse = LMath.toVector3d(camera.m_252775_()).normalize();
            Vector2d lookImpulseHorizon = new Vector2d(lookImpulse.x, lookImpulse.z).normalize((double)event.forwardImpulse);
            Vector2d leftImpulseHorizon = new Vector2d(leftImpulse.x, leftImpulse.z).normalize((double)event.leftImpulse);
            lookImpulseHorizon.add((Vector2dc)leftImpulseHorizon, ThirdPersonStatus.impulseHorizon);
            lookImpulse.mul((double)event.forwardImpulse);
            leftImpulse.mul((double)event.leftImpulse);
            lookImpulse.add((Vector3dc)leftImpulse, ThirdPersonStatus.impulse);
            double length = ThirdPersonStatus.impulseHorizon.length();
            if (length > 1.0E-5) {
                if (length > 1.0) {
                    ThirdPersonStatus.impulseHorizon.div(length, length);
                }
                float playerYRot = ThirdPerson.ENTITY_AGENT.getRawPlayerEntity().m_5675_(Minecraft.m_91087_().m_91296_());
                Vector2d playerLookHorizon = LMath.directionFromRotationDegree(playerYRot).normalize();
                Vector2d playerLeftHorizon = LMath.directionFromRotationDegree(playerYRot - 90.0f).normalize();
                event.forwardImpulse = (float)ThirdPersonStatus.impulseHorizon.dot((Vector2dc)playerLookHorizon);
                event.leftImpulse = (float)ThirdPersonStatus.impulseHorizon.dot((Vector2dc)playerLeftHorizon);
            }
        }
    }

    private static boolean onRenderEntity(RenderEntityEvent event) {
        if (ThirdPerson.isAvailable() && ThirdPersonStatus.isRenderingInThirdPerson() && event.entity == ThirdPerson.ENTITY_AGENT.getRawCameraEntity()) {
            return ThirdPersonStatus.shouldRenderCameraEntity(event.partialTick);
        }
        return true;
    }

    private static void onHandleKeybindsStart() {
        if (ThirdPerson.isAvailable()) {
            Config config = ThirdPerson.getConfig();
            if (ThirdPersonStatus.isRenderingInThirdPerson() && ThirdPerson.ENTITY_AGENT.isInteracting()) {
                Minecraft.m_91087_().f_91063_.m_109087_(1.0f);
            }
        }
    }

    private static void onMouseTurnPlayerStart(MouseTurnPlayerStartEvent event) {
        if (ThirdPerson.isAvailable() && ThirdPersonStatus.isAdjustingCameraOffset() && !ThirdPersonStatus.shouldCameraTurnWithEntity()) {
            if (event.accumulatedDX == 0.0 && event.accumulatedDY == 0.0) {
                return;
            }
            Config config = ThirdPerson.getConfig();
            Window window = Minecraft.m_91087_().m_91268_();
            Vector2d screenSize = new Vector2d((double)window.m_85443_(), (double)window.m_85444_());
            CameraOffsetScheme scheme = config.getCameraOffsetScheme();
            AbstractCameraOffsetMode mode = scheme.getMode();
            if (mode.isCentered()) {
                double topOffset = mode.getCenterOffsetRatio();
                topOffset += -event.accumulatedDY / screenSize.y;
                topOffset = LMath.clamp(topOffset, -1.0, 1.0);
                mode.setCenterOffsetRatio(topOffset);
            } else {
                Vector2d offset = mode.getSideOffsetRatio(new Vector2d());
                offset.sub((Vector2dc)new Vector2d(event.accumulatedDX, event.accumulatedDY).div(screenSize));
                LMath.clamp(offset, -1.0, 1.0);
                scheme.setSide(Math.signum(offset.x));
                mode.setSideOffsetRatio(offset);
            }
            event.cancelDefault();
        }
    }

    private static void onEntityTurnStart(EntityTurnStartEvent event) {
        if (ThirdPerson.isAvailable() && ThirdPersonStatus.isRenderingInThirdPerson() && !ThirdPersonStatus.shouldCameraTurnWithEntity()) {
            ThirdPerson.CAMERA_AGENT.turnCamera(event.dYRot, event.dXRot);
            event.cancelDefault();
        }
    }

    public static void resetPlayer() {
        ThirdPerson.resetFiniteCheckers();
        ThirdPerson.ENTITY_AGENT.reset();
        ThirdPerson.CAMERA_AGENT.reset();
    }

    @NotNull
    private static EventResult onMouseScrolled(@NotNull Minecraft minecraft, double amountX, double amountY) {
        int offset = (int)(-Math.signum(amountY));
        if (offset == 0 || !ThirdPersonStatus.isAdjustingCameraDistance()) {
            return EventResult.pass();
        }
        Config config = ThirdPerson.getConfig();
        double dist = config.getCameraOffsetScheme().getMode().getDistanceLimit();
        dist = config.getDistanceMonoList().offset(dist, offset);
        config.getCameraOffsetScheme().getMode().setDistanceLimit(dist);
        return EventResult.interruptFalse();
    }

    public static void onStartAdjustingCameraOffset() {
    }

    public static void onStopAdjustingCameraOffset() {
        ThirdPerson.CONFIG_MANAGER.lazySave();
    }
}

