/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.effects;

import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleData;
import com.eeeab.eeeabsmobs.client.particle.util.ParticleComponent;
import com.eeeab.eeeabsmobs.client.particle.util.anim.AnimData;
import com.eeeab.eeeabsmobs.client.util.ModParticleUtils;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityAbsBeam;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityScorch;
import com.eeeab.eeeabsmobs.sever.entity.guling.EntityNamelessGuardian;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import com.eeeab.eeeabsmobs.sever.util.damage.EMDamageSource;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityGuardianLaser
extends EntityAbsBeam {
    public static final double GUARDIAN_RADIUS = 32.0;
    private static final EntityDataAccessor<Boolean> DATA_IS_PLAYER = SynchedEntityData.m_135353_(EntityGuardianLaser.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @OnlyIn(value=Dist.CLIENT)
    private Vec3[] attractorPos;

    public EntityGuardianLaser(EntityType<? extends EntityGuardianLaser> type, Level level) {
        super(type, level, 20);
        if (level.f_46443_) {
            this.attractorPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
    }

    public EntityGuardianLaser(EntityType<? extends EntityGuardianLaser> type, Level world, LivingEntity caster, double x, double y, double z, float yaw, float pitch, int duration) {
        this(type, world);
        this.caster = caster;
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setDuration(duration);
        this.m_6034_(x, y, z);
        this.calculateEndPos(32.0);
        if (!this.m_9236_().f_46443_) {
            this.setCasterId(caster.m_19879_());
        }
    }

    @Override
    public void beamTick() {
        if (!this.m_9236_().f_46443_) {
            if (this.isPlayer() && this.caster instanceof Player) {
                this.updateWithPlayer();
            } else if (this.caster instanceof EntityNamelessGuardian) {
                this.updateWithGuardian();
            } else if (this.caster != null) {
                this.updateWithEntity(0.0f, 0.75f);
            }
        }
        if (this.caster != null) {
            this.yaw = (float)Math.toRadians(this.caster.f_20885_ + 90.0f);
            this.pitch = (float)(-Math.toRadians(this.caster.m_146909_()));
        }
        if (this.m_9236_().f_46443_ && this.f_19797_ <= this.getCountDown() / 2 && this.caster != null) {
            double rootX = this.caster.m_20185_();
            double rootY = this.caster.m_20186_() + (double)(this.caster.m_20206_() / 2.0f) + (double)0.3f;
            double rootZ = this.caster.m_20189_();
            this.attractorPos[0] = new Vec3(rootX, rootY, rootZ);
            ModParticleUtils.advAttractorParticle((ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.ADV_ORB.get()), (Entity)this.caster, 12, 0.5f, 5.0f, 8.0f, new ParticleComponent[]{new ParticleComponent.Attractor(this.attractorPos, 1.6f, 0.0f, ParticleComponent.Attractor.EnumAttractorBehavior.EXPONENTIAL), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, AnimData.KeyTrack.startAndEnd(0.0f, 0.6f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, AnimData.KeyTrack.startAndEnd(6.0f, 3.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.RED, AnimData.KeyTrack.startAndEnd(1.0f, 0.3f), false)}, false);
        }
        if (this.f_19797_ >= this.getCountDown()) {
            this.calculateEndPos(this.isPlayer() ? (Double)EMConfigHandler.COMMON.ENTITY.guardianLaserShootRadius.get() : 32.0);
            List<LivingEntity> hit = this.raytraceEntities(this.m_9236_(), new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), new Vec3(this.endPosX, this.endPosY, this.endPosZ)).getEntities();
            if (this.blockSide != null) {
                if (!this.m_9236_().f_46443_ && this.f_19797_ % 5 == 0) {
                    BlockPos minPos = new BlockPos(Mth.m_14107_((double)(this.collidePosX - 0.5)), Mth.m_14107_((double)(this.collidePosY - 0.5)), Mth.m_14107_((double)(this.collidePosZ - 0.5)));
                    BlockPos maxPos = new BlockPos(Mth.m_14107_((double)(this.collidePosX + 0.5)), Mth.m_14107_((double)(this.collidePosY + 0.5)), Mth.m_14107_((double)(this.collidePosZ + 0.5)));
                    BlockPos.m_121990_((BlockPos)minPos, (BlockPos)maxPos).forEach(pos -> {
                        if (ModEntityUtils.canDestroyBlock(this.m_9236_(), pos, this, ((Double)EMConfigHandler.COMMON.ENTITY.guardianLaserCanDestroyMaxBlockHardness.get()).floatValue())) {
                            LivingEntity patt5214$temp;
                            if (ModEntityUtils.canMobDestroy(this) && (patt5214$temp = this.caster) instanceof EntityNamelessGuardian) {
                                EntityNamelessGuardian guardian = (EntityNamelessGuardian)patt5214$temp;
                                this.m_9236_().m_46961_(pos, guardian.checkCanDropItems());
                            } else if (this.isPlayer() && this.caster instanceof Player && ((Boolean)EMConfigHandler.COMMON.ENTITY.guardianLaserCanDestroyBlock.get()).booleanValue()) {
                                this.m_9236_().m_46961_(pos, true);
                            }
                        }
                    });
                }
                this.spawnExplosionParticles();
                if (!this.m_9236_().f_46443_ && !this.isPlayer() && ((Boolean)EMConfigHandler.COMMON.ENTITY.enableGenerateScorchEntity.get()).booleanValue()) {
                    EntityScorch scorch = new EntityScorch(this.m_9236_(), this.prevCollidePosX, this.prevCollidePosY, this.prevCollidePosZ);
                    this.m_9236_().m_7967_((Entity)scorch);
                }
            }
            if (!this.m_9236_().f_46443_) {
                for (LivingEntity target : hit) {
                    target.m_20254_(3);
                    LivingEntity livingEntity = this.caster;
                    if (livingEntity instanceof EntityNamelessGuardian) {
                        EntityNamelessGuardian guardian = (EntityNamelessGuardian)livingEntity;
                        guardian.guardianHurtTarget(EMDamageSource.guardianLaserAttack(this, (Entity)guardian), guardian, target, 0.035f, 0.22f, 1.0f, guardian.isChallengeMode(), false, false);
                        continue;
                    }
                    if (this.caster == null) continue;
                    target.m_6469_(this.m_269291_().m_269333_(this.caster), 5.0f + target.m_21233_() * 0.01f);
                }
            }
        }
    }

    @Override
    protected void spawnExplosionParticles() {
        for (int i = 0; i < 2; ++i) {
            float velocity = 0.2f;
            float yaw = (float)((double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI);
            float motionY = this.f_19796_.m_188501_() * 0.2f;
            float motionX = 0.2f * Mth.m_14089_((float)yaw);
            float motionZ = 0.2f * Mth.m_14031_((float)yaw);
            this.m_9236_().m_7106_((ParticleOptions)ParticleInit.GUARDIAN_SPARK.get(), this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, (double)motionX, (double)motionY, (double)motionZ);
        }
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.collidePosX, this.collidePosY, this.collidePosZ, 0.0, 0.0, 0.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_PLAYER, (Object)false);
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        if (this.caster == null) {
            this.m_146870_();
        }
    }

    public boolean isPlayer() {
        return (Boolean)this.m_20088_().m_135370_(DATA_IS_PLAYER);
    }

    public void setPlayer(boolean flag) {
        this.m_20088_().m_135381_(DATA_IS_PLAYER, (Object)flag);
    }

    public boolean m_6783_(double distance) {
        Double radius = (Double)EMConfigHandler.COMMON.ENTITY.guardianLaserShootRadius.get();
        return this.isPlayer() ? distance < radius * radius * 2.0 : distance < 2048.0;
    }

    private void updateWithPlayer() {
        this.setYaw((float)Math.toRadians(this.caster.f_20885_ + 90.0f));
        this.setPitch((float)Math.toRadians(-this.caster.m_146909_()));
        Vec3 vecOffset = this.caster.m_20154_().m_82541_().m_82490_(1.0);
        this.m_6034_(this.caster.m_20185_() + vecOffset.m_7096_(), this.caster.m_20186_() + (double)(this.caster.m_20206_() * 0.5f) + vecOffset.m_7098_(), this.caster.m_20189_() + vecOffset.m_7094_());
    }

    private void updateWithGuardian() {
        this.updateWithEntity(1.35f, 0.8f);
    }

    private void updateWithEntity(float offset, float yOffset) {
        double radians = Math.toRadians(this.caster.f_20885_ + 90.0f);
        this.setYaw((float)radians);
        this.setPitch((float)((double)(-this.caster.m_146909_()) * Math.PI / 180.0));
        double offsetX = Math.cos(radians) * (double)offset;
        double offsetZ = Math.sin(radians) * (double)offset;
        this.m_6034_(this.caster.m_20185_() + offsetX, this.caster.m_20227_((double)yOffset), this.caster.m_20189_() + offsetZ);
    }
}

