/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.ai.goal.animate;

import com.eeeab.animate.server.ai.AnimationAI;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.eeeabsmobs.sever.entity.guling.EntityNamelessGuardian;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class GuardianPounceAttackGoal
extends AnimationAI<EntityNamelessGuardian> {
    private final EntityNamelessGuardian entity;
    private Vec3 pounceVec = Vec3.f_82478_;
    private final float speedMultiplier;
    private double moveSpeed;
    private boolean isPowered;
    private float madnessSpeedMultiplier;
    private int consecutive;

    public GuardianPounceAttackGoal(EntityNamelessGuardian entity, float speedMultiplier) {
        super(entity);
        this.entity = entity;
        this.speedMultiplier = speedMultiplier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.isPowered = this.entity.m_7090_();
        this.madnessSpeedMultiplier = this.speedMultiplier;
        this.pounceVec = Vec3.f_82478_;
        this.moveSpeed = this.entity.m_21133_(Attributes.f_22279_);
        if (this.isPowered) {
            this.madnessSpeedMultiplier += 0.5f;
        }
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.madnessSpeedMultiplier = 0.0f;
        this.isPowered = false;
        this.consecutive = 0;
    }

    @Override
    protected boolean test(Animation animation) {
        return animation == this.entity.pounceAttackAnimation1 || animation == this.entity.pounceAttackAnimation2 || animation == this.entity.pounceAttackAnimation3;
    }

    public void m_8037_() {
        float baseDamageMultiplier;
        LivingEntity target = this.entity.m_5448_();
        float f = baseDamageMultiplier = this.isPowered ? 0.8f : 0.6f;
        if (this.entity.getAnimation() == this.entity.pounceAttackAnimation1) {
            this.entity.anchorToGround();
            int tick = this.entity.getAnimationTick();
            if (tick == 1) {
                this.entity.m_5496_((SoundEvent)SoundInit.NAMELESS_GUARDIAN_PRE_POUNCE.get(), 1.5f, this.entity.m_6100_());
            } else if (tick >= this.entity.pounceAttackAnimation1.getDuration() - 1) {
                if (target != null) {
                    double radians = Math.toRadians(this.entity.m_146908_() + 90.0f);
                    this.pounceVec = new Vec3(Math.cos(radians), 0.0, Math.sin(radians));
                    this.entity.playAnimation(this.entity.pounceAttackAnimation2);
                } else {
                    this.entity.playAnimation(this.entity.pounceAttackAnimation3);
                }
            }
            if (target != null) {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
            }
        } else if (this.entity.getAnimation() == this.entity.pounceAttackAnimation2) {
            int keyFrame;
            int tick = this.entity.getAnimationTick();
            int n = keyFrame = this.isPowered ? 24 : 28;
            if (tick < keyFrame && this.pounceVec.m_82553_() != 0.0) {
                this.entity.m_20334_(this.pounceVec.f_82479_ * this.moveSpeed * (double)this.madnessSpeedMultiplier, -this.entity.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get()) * 5.0, this.pounceVec.f_82481_ * this.moveSpeed * (double)this.speedMultiplier);
                if (!this.entity.m_9236_().f_46443_ && ModEntityUtils.canMobDestroy((Entity)this.entity)) {
                    AABB bb = this.entity.m_20191_();
                    int minx = Mth.m_14107_((double)(bb.f_82288_ - 0.75));
                    int miny = Mth.m_14107_((double)(bb.f_82289_ + 0.0));
                    int minz = Mth.m_14107_((double)(bb.f_82290_ - 0.75));
                    BlockPos min = new BlockPos(minx, miny, minz);
                    int maxx = Mth.m_14107_((double)(bb.f_82291_ + 0.75));
                    int maxy = Mth.m_14107_((double)(bb.f_82292_ + 0.15));
                    int maxz = Mth.m_14107_((double)(bb.f_82293_ + 0.75));
                    BlockPos max = new BlockPos(maxx, maxy, maxz);
                    if (this.entity.m_9236_().m_46832_(min, max)) {
                        BlockPos.m_121990_((BlockPos)min, (BlockPos)max).filter(pos -> ModEntityUtils.canDestroyBlock(this.entity.m_9236_(), pos, (Entity)this.entity, 2.0f)).forEach(pos -> this.entity.m_9236_().m_46961_(pos, this.entity.checkCanDropItems()));
                    }
                }
                if (tick % 2 == 0) {
                    List<LivingEntity> livingEntities = this.entity.getNearByLivingEntities(2.5, 5.0, 2.5, 5.0);
                    for (LivingEntity hitEntity : livingEntities) {
                        float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this.entity, hitEntity);
                        float entityHitDistance = (float)Math.sqrt((hitEntity.m_20189_() - this.entity.m_20189_()) * (hitEntity.m_20189_() - this.entity.m_20189_()) + (hitEntity.m_20185_() - this.entity.m_20185_()) * (hitEntity.m_20185_() - this.entity.m_20185_())) - hitEntity.m_20205_() / 2.0f;
                        if (!(entityHitDistance <= 3.0f && entityRelativeAngle <= 60.0f && entityRelativeAngle >= -60.0f || entityRelativeAngle >= 300.0f) && !(entityRelativeAngle <= -300.0f)) continue;
                        this.entity.guardianHurtTarget(this.entity, hitEntity, 0.05f, 1.0f, baseDamageMultiplier, false, false, false);
                        double ratioX = Math.sin(this.entity.m_146908_() * ((float)Math.PI / 180));
                        double ratioZ = -Math.cos(this.entity.m_146908_() * ((float)Math.PI / 180));
                        ModEntityUtils.forceKnockBack((LivingEntity)this.entity, hitEntity, 1.5f, ratioX, ratioZ, true);
                        double duration = 1.5;
                        if (Difficulty.HARD.equals((Object)this.entity.m_9236_().m_46791_())) {
                            duration = 2.5;
                        }
                        this.entity.stun(null, hitEntity, (int)(duration * 20.0), this.entity.isChallengeMode());
                    }
                }
            } else {
                this.entity.playAnimation(this.entity.pounceAttackAnimation3);
            }
        } else if (this.entity.getAnimation() == this.entity.pounceAttackAnimation3) {
            this.entity.m_20334_(0.0, this.entity.m_20184_().m_7098_(), 0.0);
            int maxExtraConsecutive = 2;
            if (this.consecutive < maxExtraConsecutive && this.entity.m_5448_() != null && this.entity.getAnimationTick() <= 6 && this.entity.getAnimationTick() > 1 && this.checkModeOrPreventTimeouts() && this.entity.targetDistance < 16.0f && this.entity.targetDistance > 4.0f && (this.entity.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get()) && this.entity.m_217043_().m_188503_(3 - this.consecutive) == 0 || this.entity.m_217043_().m_188503_(10) == 0)) {
                ++this.consecutive;
                this.entity.playAnimation(this.entity.pounceAttackAnimation1);
            }
        }
    }

    private boolean checkModeOrPreventTimeouts() {
        return this.entity.isChallengeMode() || this.entity.getMadnessTick() > 200 && this.entity.m_7090_();
    }
}

