/*
 * Decompiled with CFR 0.152.
 */
package com.dragon.dragonheart.Item;

import com.dragon.dragonheart.CuriosItem;
import com.dragon.dragonheart.config.ConfigCommon;
import com.dragon.dragonheart.connect.ThirstConnect;
import com.dragon.dragonheart.utils.AddAttributeSafety;
import com.dragon.dragonheart.utils.RemoveAttributeSafety;
import com.dragon.dragonheart.utils.TooltipWithoutShift;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class WolfHead {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"dragonheart");
    static UUID modifierUUID = UUID.fromString("4D1A8F41-F557-6627-1B05-150F9827D52C");
    public static final RegistryObject<Item> WOLF_HEAD = ITEMS.register("wolf_head", () -> new CuriosItem(new Item.Properties().m_41487_(1).m_41486_()){

        @Override
        protected void equipfirst(LivingEntity livingEntity) {
            AttributeModifier modifier = new AttributeModifier(modifierUUID, "wolf head add health", ((Double)ConfigCommon.WOLF_HEAD_ADD_HEALTH.get()).doubleValue(), AttributeModifier.Operation.ADDITION);
            AddAttributeSafety.addModifierSafety(livingEntity, Attributes.f_22276_, modifier);
        }

        @Override
        protected void equipmentTick(LivingEntity livingEntity) {
            if (ModList.get().isLoaded("thirst")) {
                ThirstConnect.neverThirsty(livingEntity);
            }
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_36324_().m_38717_(5.0f);
                player.m_36324_().m_38705_(20);
                player.m_36324_().m_150378_(0.0f);
            }
        }

        @Override
        protected void unequip(LivingEntity livingEntity) {
            AttributeModifier modifier = new AttributeModifier(modifierUUID, "wolf head add health", ((Double)ConfigCommon.WOLF_HEAD_ADD_HEALTH.get()).doubleValue(), AttributeModifier.Operation.ADDITION);
            RemoveAttributeSafety.removeModifierSafety(livingEntity, Attributes.f_22276_, modifier);
            livingEntity.m_21153_(livingEntity.m_21223_());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
            super.m_7373_(stack, worldIn, tooltip, flagIn);
            if (Screen.m_96638_()) {
                if (ChatFormatting.m_126647_((int)167) != null) {
                    tooltip.add((Component)Component.m_237115_((String)"item.dragonheart.ability.desc").m_130940_(ChatFormatting.m_126647_((int)167)));
                    tooltip.add((Component)Component.m_237115_((String)"item.dragonheart.wolf_head.desc").m_130940_(ChatFormatting.m_126647_((int)167)));
                    tooltip.add((Component)Component.m_237119_().m_130946_("+").m_130946_(String.valueOf(ConfigCommon.WOLF_HEAD_ADD_HEALTH.get())).m_7220_((Component)Component.m_237115_((String)"item.dragonheart.max_health.desc")).m_130940_(ChatFormatting.m_126647_((int)167)));
                    tooltip.add((Component)Component.m_237110_((String)"item.dragonheart.wolf_head.desc2", (Object[])new Object[]{(double)((Integer)ConfigCommon.WOLF_HEAD_WITHER_TIME.get()).intValue() / 20.0, (Integer)ConfigCommon.WOLF_HEAD_WITHER_LEVEL.get() - 1}).m_130940_(ChatFormatting.m_126647_((int)167)));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"item.dragonheart.ability.desc").m_130940_(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.m_237115_((String)"item.dragonheart.wolf_head.desc").m_130940_(ChatFormatting.DARK_GREEN));
                    tooltip.add((Component)Component.m_237119_().m_130946_("+").m_130946_(String.valueOf(ConfigCommon.WOLF_HEAD_ADD_HEALTH.get())).m_7220_((Component)Component.m_237115_((String)"item.dragonheart.max_health.desc")).m_130940_(ChatFormatting.RED));
                    tooltip.add((Component)Component.m_237110_((String)"item.dragonheart.wolf_head.desc2", (Object[])new Object[]{(double)((Integer)ConfigCommon.WOLF_HEAD_WITHER_TIME.get()).intValue() / 20.0, (int)((Integer)ConfigCommon.WOLF_HEAD_WITHER_LEVEL.get())}).m_130940_(ChatFormatting.DARK_GRAY));
                }
            } else {
                TooltipWithoutShift.tooltipWithoutShift(tooltip, "wolf_head");
            }
        }

        @NotNull
        public Component m_7626_(@NotNull ItemStack stack) {
            return Component.m_237115_((String)super.m_7626_(stack).getString()).m_130940_(ChatFormatting.RED);
        }
    });

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

