/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.snowwaifu.common.entity.api;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;

public abstract class TamableMob
extends PathfinderMob
implements OwnableEntity {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(TamableMob.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID_ID = SynchedEntityData.m_135353_(TamableMob.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private boolean orderedToSit;

    protected TamableMob(EntityType<? extends TamableMob> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.reassessTameGoals();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNER_UUID_ID, Optional.empty());
    }

    public void m_7380_(CompoundTag p_21819_) {
        super.m_7380_(p_21819_);
        if (this.m_21805_() != null) {
            p_21819_.m_128362_("Owner", this.m_21805_());
        }
        p_21819_.m_128379_("Sitting", this.orderedToSit);
    }

    public void m_7378_(CompoundTag p_21815_) {
        UUID uuid;
        super.m_7378_(p_21815_);
        if (p_21815_.m_128403_("Owner")) {
            uuid = p_21815_.m_128342_("Owner");
        } else {
            String s = p_21815_.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable throwable) {
                this.setTame(false);
            }
        }
        this.orderedToSit = p_21815_.m_128471_("Sitting");
        this.setInSittingPose(this.orderedToSit);
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_();
    }

    protected void spawnTamingParticles(boolean p_21835_) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!p_21835_) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void m_7822_(byte p_21807_) {
        if (p_21807_ == 7) {
            this.spawnTamingParticles(true);
        } else if (p_21807_ == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.m_7822_(p_21807_);
        }
    }

    public boolean isTame() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    public void setTame(boolean p_21836_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (p_21836_) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 4)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
        this.reassessTameGoals();
    }

    protected void reassessTameGoals() {
    }

    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setInSittingPose(boolean p_21838_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (p_21838_) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID p_21817_) {
        this.f_19804_.m_135381_(DATA_OWNER_UUID_ID, Optional.ofNullable(p_21817_));
    }

    public void tame(Player p_21829_) {
        this.setTame(true);
        this.setOwnerUUID(p_21829_.m_20148_());
    }

    public boolean m_6779_(LivingEntity target) {
        return !this.isOwnedBy(target) && super.m_6779_(target);
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        return true;
    }

    public boolean isOwnedBy(LivingEntity p_21831_) {
        return p_21831_ == this.m_269323_();
    }

    public Team m_5647_() {
        LivingEntity livingentity;
        if (this.isTame() && (livingentity = this.m_269323_()) != null) {
            return livingentity.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_7307_(Entity entity) {
        if (this.isTame()) {
            LivingEntity livingentity = this.m_269323_();
            if (entity == livingentity) {
                return true;
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    public void m_6667_(DamageSource src) {
        Component deathMessage = this.m_21231_().m_19293_();
        super.m_6667_(src);
        if (this.f_20890_ && !this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && this.m_269323_() instanceof ServerPlayer) {
            this.m_269323_().m_213846_(deathMessage);
        }
    }
}

