/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.vellamo;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.gui.vanilla.mode.QualityMode;
import team.teampotato.ruok.mixin.minecraft.accessor.MinecraftClientAccessor;
import team.teampotato.ruok.util.Quality;
import team.teampotato.ruok.util.ToastUtil;

public class Score {
    private static final double cpu;
    private static final double ram;

    @Contract(pure=true)
    public static void runVellamo() {
        int fps = MinecraftClientAccessor.getFPS();
        double time = RuOK.get().startTime;
        double score = 0.5 * (100.0 - cpu) + 0.4 * (100.0 - ram) + 0.1 * (double)fps + 0.1 * (1000.0 / time);
        Component level = Score.calculatePerformanceLevel(score);
        ToastUtil.send((Component)Component.m_237115_((String)"ruok.quality.runscore.info"), (Component)Component.m_237110_((String)"ruok.vellamo.recommend", (Object[])new Object[]{level}));
    }

    @NotNull
    private static Component calculatePerformanceLevel(double score) {
        if (score > 90.0) {
            Quality.set(QualityMode.ULTRA);
            return Component.m_237115_((String)"ruok.quality.ultra");
        }
        if (score > 70.0) {
            Quality.set(QualityMode.HIGH);
            return Component.m_237115_((String)"ruok.quality.high");
        }
        if (score > 50.0) {
            Quality.set(QualityMode.NORMAL);
            return Component.m_237115_((String)"ruok.quality.normal");
        }
        if (score > 30.0) {
            Quality.set(QualityMode.LOW);
            return Component.m_237115_((String)"ruok.quality.low");
        }
        Quality.set(QualityMode.CRITICAL);
        return Component.m_237115_((String)"ruok.quality.critical");
    }

    static {
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        double mem = (double)osmxb.getFreeMemorySize() / (double)osmxb.getTotalMemorySize();
        double memoryLoad = (1.0 - mem) * 100.0;
        double cpuLoad = osmxb.getCpuLoad() * 100.0;
        memoryLoad = Double.parseDouble(String.format("%.1f", memoryLoad));
        cpu = cpuLoad = Double.parseDouble(String.format("%.1f", cpuLoad));
        ram = memoryLoad;
    }
}

