/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.gui.vanilla.options.widget;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionListWidget
extends ContainerObjectSelectionList<WidgetEntry> {
    public OptionListWidget(Minecraft client, int width, int height, int k, int l, int m) {
        super(client, width, height, k, l, m);
        this.f_93394_ = false;
    }

    public int addSingleOptionEntry(OptionInstance<?> option) {
        return this.m_7085_((AbstractSelectionList.Entry)WidgetEntry.create(this.f_93386_.f_91066_, this.f_93388_, option));
    }

    public void addOptionEntry(OptionInstance<?> firstOption, @Nullable OptionInstance<?> secondOption) {
        this.m_7085_((AbstractSelectionList.Entry)WidgetEntry.create(this.f_93386_.f_91066_, this.f_93388_, firstOption, secondOption));
    }

    public void addAll(OptionInstance<?>[] options) {
        for (int i = 0; i < options.length; i += 2) {
            this.addOptionEntry(options[i], i < options.length - 1 ? options[i + 1] : null);
        }
    }

    public int m_5759_() {
        return 400;
    }

    protected int m_5756_() {
        return super.m_5756_() + 32;
    }

    @Nullable
    public AbstractWidget getWidgetFor(OptionInstance<?> option) {
        WidgetEntry widgetEntry;
        AbstractWidget clickableWidget;
        Iterator var2 = this.m_6702_().iterator();
        do {
            if (!var2.hasNext()) {
                return null;
            }
            widgetEntry = (WidgetEntry)((Object)var2.next());
        } while ((clickableWidget = widgetEntry.optionsToWidgets.get(option)) == null);
        return clickableWidget;
    }

    public Optional<AbstractWidget> getHoveredWidget(double mouseX, double mouseY) {
        for (WidgetEntry widgetEntry : this.m_6702_()) {
            for (AbstractWidget clickableWidget : widgetEntry.widgets) {
                if (!clickableWidget.m_5953_(mouseX, mouseY)) continue;
                return Optional.of(clickableWidget);
            }
        }
        return Optional.empty();
    }

    protected static class WidgetEntry
    extends ContainerObjectSelectionList.Entry<WidgetEntry> {
        final Map<OptionInstance<?>, AbstractWidget> optionsToWidgets;
        final List<AbstractWidget> widgets;

        private WidgetEntry(@NotNull Map<OptionInstance<?>, AbstractWidget> optionsToWidgets) {
            this.optionsToWidgets = optionsToWidgets;
            this.widgets = ImmutableList.copyOf(optionsToWidgets.values());
        }

        @Contract(value="_, _, _ -> new")
        @NotNull
        public static WidgetEntry create(Options options, int width, OptionInstance<?> option) {
            return new WidgetEntry((Map<OptionInstance<?>, AbstractWidget>)ImmutableMap.of(option, (Object)option.m_231507_(options, width / 2 - 155, 0, 310)));
        }

        @NotNull
        public static WidgetEntry create(Options options, int width, @NotNull OptionInstance<?> firstOption, @Nullable OptionInstance<?> secondOption) {
            AbstractWidget clickableWidget = firstOption.m_231507_(options, width / 2 - 155, 0, 150);
            return secondOption == null ? new WidgetEntry((Map<OptionInstance<?>, AbstractWidget>)ImmutableMap.of(firstOption, (Object)clickableWidget)) : new WidgetEntry((Map<OptionInstance<?>, AbstractWidget>)ImmutableMap.of(firstOption, (Object)clickableWidget, secondOption, (Object)secondOption.m_231507_(options, width / 2 - 155 + 160, 0, 150)));
        }

        public void m_6311_(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.widgets.forEach(widget -> {
                widget.m_253211_(y);
                widget.m_88315_(context, mouseX, mouseY, tickDelta);
            });
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.widgets;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.widgets;
        }
    }
}

