/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.gui.vanilla.options;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.gui.vanilla.mode.QualityMode;
import team.teampotato.ruok.gui.vanilla.mode.WeatherMode;
import team.teampotato.ruok.gui.vanilla.options.sop.QualityModeOptions;
import team.teampotato.ruok.gui.vanilla.options.sop.WeatherModeOptions;
import team.teampotato.ruok.util.Render;
import team.teampotato.ruok.vellamo.Score;

public class RuOptions {
    private final OptionInstance<WeatherMode> weatherMode;
    private final OptionInstance<Integer> entityDistance = RuOptions.getEntityDistanceOptions();
    private final OptionInstance<Integer> entityCount;
    private final OptionInstance<Boolean> onCull;
    private final OptionInstance<QualityMode> qualityMode;
    private final OptionInstance<Boolean> runScore;
    private final OptionInstance<Boolean> chatFix;
    private final OptionInstance<Boolean> tntExplosions;
    private final OptionInstance<Boolean> fastItem;
    private final OptionInstance<Boolean> displayItem;
    private final OptionInstance<Boolean> itemCount;

    public RuOptions() {
        this.weatherMode = WeatherModeOptions.getWeatherModeSimpleOption();
        this.onCull = RuOptions.getOnCullOptions();
        this.entityCount = RuOptions.getEntityCountOptions();
        this.qualityMode = QualityModeOptions.getQualityModeSimpleOption();
        this.runScore = RuOptions.getRunCoreOptions();
        this.chatFix = RuOptions.getChatFixOptions();
        this.tntExplosions = RuOptions.getTNTExplosions();
        this.fastItem = RuOptions.getFastItem();
        this.displayItem = RuOptions.getDisplayItem();
        this.itemCount = RuOptions.getRenderItemCount();
    }

    public OptionInstance<?>[] getOptions() {
        ArrayList<Object> options = new ArrayList<Object>(List.of());
        options.add(this.getOnCull());
        options.add(this.getEntityDistance());
        options.add(this.getEntityCount());
        options.add(this.getWeatherMode());
        options.add(this.getQualityMode());
        options.add(this.getRunScore());
        options.add(this.getChatFix());
        options.add(this.getFastItems());
        options.add(this.getDisplayItems());
        options.add(this.getTntExplosions());
        options.add(this.getItemCount());
        return (OptionInstance[])options.toArray(OptionInstance[]::new);
    }

    @NotNull
    private static OptionInstance<Boolean> getOnCullOptions() {
        return OptionInstance.m_257874_((String)"ruok.quality.cull.info", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.quality.cull.tooltip")), (boolean)true, value -> {
            RuOK.get().onCull = value;
            RuOK.save();
        });
    }

    @NotNull
    private static OptionInstance<Boolean> getRunCoreOptions() {
        return OptionInstance.m_257874_((String)"ruok.quality.runscore.info", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.quality.runscore.tooltip")), (boolean)false, value -> Score.runVellamo());
    }

    @NotNull
    private static OptionInstance<Integer> getEntityDistanceOptions() {
        return new OptionInstance("ruok.quality.distance.info", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.quality.distance.tooltip")), (optionText, value) -> Options.m_231921_((Component)optionText, (Component)Component.m_237110_((String)"ruok.quality.options.block", (Object[])new Object[]{value})), (OptionInstance.ValueSet)new OptionInstance.IntRange(2, 512), (Object)RuOK.get().entitiesDistance, value -> {
            RuOK.get().entitiesDistance = value;
            RuOK.save();
        });
    }

    @NotNull
    private static OptionInstance<Integer> getEntityCountOptions() {
        return new OptionInstance("ruok.quality.entity.info", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.quality.entity.tooltip")), (optionText, value) -> Options.m_231921_((Component)optionText, (Component)Component.m_237110_((String)"ruok.quality.options.entity", (Object[])new Object[]{value})), (OptionInstance.ValueSet)new OptionInstance.IntRange(8, 1024), (Object)RuOK.get().maxEntityEntities, value -> {
            RuOK.get().maxEntityEntities = value;
            RuOK.save();
            Render.reloadRenderEntity();
        });
    }

    @NotNull
    private static OptionInstance<Boolean> getChatFixOptions() {
        return OptionInstance.m_257874_((String)"ruok.quality.chatfix.info", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.quality.chatfix.tooltip")), (boolean)RuOK.get().chatFix, value -> {
            RuOK.get().chatFix = value;
            RuOK.save();
        });
    }

    @NotNull
    private static OptionInstance<Boolean> getTNTExplosions() {
        return OptionInstance.m_257874_((String)"ruok.quality.tntexplosions.info", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.quality.tntexplosions.tooltip")), (boolean)RuOK.get().RenderTNTExplosions, value -> {
            RuOK.get().RenderTNTExplosions = value;
            RuOK.save();
        });
    }

    @NotNull
    private static OptionInstance<Boolean> getFastItem() {
        return OptionInstance.m_257874_((String)"ruok.quality.fastitem.info", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.quality.fastitem.tooltip")), (boolean)RuOK.get().FastItemRender, value -> {
            RuOK.get().FastItemRender = value;
            RuOK.save();
        });
    }

    @NotNull
    private static OptionInstance<Boolean> getDisplayItem() {
        return OptionInstance.m_257874_((String)"ruok.quality.displayitem.info", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.quality.displayitem.tooltip")), (boolean)RuOK.get().RenderDisplayItem, value -> {
            RuOK.get().RenderDisplayItem = value;
            RuOK.save();
        });
    }

    @NotNull
    private static OptionInstance<Boolean> getRenderItemCount() {
        return OptionInstance.m_257874_((String)"ruok.quality.itemcount.info", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.quality.itemcount.tooltip")), (boolean)RuOK.get().isAlwaysShowItemCount, value -> {
            RuOK.get().isAlwaysShowItemCount = value;
            RuOK.save();
        });
    }

    public OptionInstance<Integer> getEntityDistance() {
        return this.entityDistance;
    }

    public OptionInstance<WeatherMode> getWeatherMode() {
        return this.weatherMode;
    }

    public OptionInstance<Boolean> getOnCull() {
        return this.onCull;
    }

    public OptionInstance<Integer> getEntityCount() {
        return this.entityCount;
    }

    public OptionInstance<QualityMode> getQualityMode() {
        return this.qualityMode;
    }

    public OptionInstance<Boolean> getRunScore() {
        return this.runScore;
    }

    public OptionInstance<Boolean> getChatFix() {
        return this.chatFix;
    }

    public OptionInstance<Boolean> getTntExplosions() {
        return this.tntExplosions;
    }

    public OptionInstance<Boolean> getItemCount() {
        return this.itemCount;
    }

    public OptionInstance<Boolean> getFastItems() {
        return this.fastItem;
    }

    public OptionInstance<Boolean> getDisplayItems() {
        return this.displayItem;
    }
}

