/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.pinin.searchers;

import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.towdium.pinin.PinIn;
import me.towdium.pinin.elements.Char;
import me.towdium.pinin.elements.Phoneme;
import me.towdium.pinin.elements.Pinyin;
import me.towdium.pinin.searchers.Searcher;
import me.towdium.pinin.utils.Accelerator;
import me.towdium.pinin.utils.Compressor;

public class TreeSearcher<T>
implements Searcher<T> {
    Node<T> root = new NDense();
    List<T> objects = new ObjectArrayList();
    List<NAcc<T>> naccs = new ArrayList<NAcc<T>>();
    final Accelerator acc;
    final Compressor strs = new Compressor();
    final PinIn context;
    final Searcher.Logic logic;
    final PinIn.Ticket ticket;
    static final int THRESHOLD = 128;

    public TreeSearcher(Searcher.Logic logic, PinIn context) {
        this.logic = logic;
        this.context = context;
        this.acc = new Accelerator(context);
        this.acc.setProvider(this.strs);
        this.ticket = context.ticket(() -> {
            this.naccs.forEach(i -> i.reload(this));
            this.acc.reset();
        });
    }

    @Override
    public void put(String name, T identifier) {
        this.ticket.renew();
        int pos = this.strs.put(name);
        int end = this.logic == Searcher.Logic.CONTAIN ? name.length() : 1;
        for (int i = 0; i < end; ++i) {
            this.root = this.root.put(this, pos + i, this.objects.size());
        }
        this.objects.add(identifier);
    }

    @Override
    public List<T> search(String s) {
        this.ticket.renew();
        this.acc.search(s);
        IntRBTreeSet ret = new IntRBTreeSet();
        this.root.get(this, (IntSet)ret, 0);
        return ret.stream().map(i -> this.objects.get((int)i)).collect(Collectors.toList());
    }

    @Override
    public PinIn context() {
        return this.context;
    }

    public void refresh() {
        this.ticket.renew();
    }

    public static class NAcc<T>
    extends NMap<T> {
        Map<Phoneme, CharSet> index = new Object2ObjectArrayMap();

        private NAcc(TreeSearcher<T> p, NMap<T> n) {
            this.children = n.children;
            this.leaves = n.leaves;
            this.reload(p);
            p.naccs.add(this);
        }

        @Override
        public void get(TreeSearcher<T> p, IntSet ret, int offset) {
            if (p.acc.search().length() == offset) {
                if (p.logic == Searcher.Logic.EQUAL) {
                    ret.addAll((IntCollection)this.leaves);
                } else {
                    this.get(p, ret);
                }
            } else {
                Node n = (Node)this.children.get(p.acc.search().charAt(offset));
                if (n != null) {
                    n.get(p, ret, offset + 1);
                }
                this.index.forEach((k, v) -> {
                    if (!k.match(p.acc.search(), offset, true).isEmpty()) {
                        v.forEach(i -> p.acc.get((char)i, offset).foreach(j -> ((Node)this.children.get((char)i)).get(p, ret, offset + j)));
                    }
                });
            }
        }

        @Override
        public NAcc<T> put(TreeSearcher<T> p, int name, int identifier) {
            super.put((TreeSearcher)p, name, identifier);
            this.index(p, p.strs.get(name));
            return this;
        }

        public void reload(TreeSearcher<T> p) {
            this.index.clear();
            this.children.keySet().forEach(i -> this.index(p, (char)i));
        }

        private void index(TreeSearcher<T> p, char c) {
            Char ch = p.context.getChar(c);
            for (Pinyin py : ch.pinyins()) {
                this.index.compute(py.phonemes()[0], (j, cs) -> {
                    if (cs == null) {
                        return new CharArraySet();
                    }
                    if (cs instanceof CharArraySet && cs.size() >= 128 && !cs.contains(c)) {
                        return new CharOpenHashSet((CharCollection)cs);
                    }
                    return cs;
                }).add(c);
            }
        }
    }

    public static class NMap<T>
    implements Node<T> {
        Char2ObjectMap<Node<T>> children;
        IntSet leaves = new IntArraySet(1);

        @Override
        public void get(TreeSearcher<T> p, IntSet ret, int offset) {
            if (p.acc.search().length() == offset) {
                if (p.logic == Searcher.Logic.EQUAL) {
                    ret.addAll((IntCollection)this.leaves);
                } else {
                    this.get(p, ret);
                }
            } else if (this.children != null) {
                this.children.forEach((c, n) -> p.acc.get(c.charValue(), offset).foreach(i -> n.get(p, ret, offset + i)));
            }
        }

        @Override
        public void get(TreeSearcher<T> p, IntSet ret) {
            ret.addAll((IntCollection)this.leaves);
            if (this.children != null) {
                this.children.forEach((c, n) -> n.get(p, ret));
            }
        }

        @Override
        public NMap<T> put(TreeSearcher<T> p, int name, int identifier) {
            if (p.strs.get(name) == '\u0000') {
                if (this.leaves.size() >= 128 && this.leaves instanceof IntArraySet) {
                    this.leaves = new IntOpenHashSet((IntCollection)this.leaves);
                }
                this.leaves.add(identifier);
            } else {
                this.init();
                char ch = p.strs.get(name);
                Node<T> sub = (NDense<T>)this.children.get(ch);
                if (sub == null) {
                    sub = new NDense<T>();
                    this.put(ch, sub);
                }
                sub = sub.put(p, name + 1, identifier);
                this.children.put(ch, sub);
            }
            return !(this instanceof NAcc) && this.children != null && this.children.size() > 32 ? new NAcc(p, this) : this;
        }

        private void put(char ch, Node<T> n) {
            this.init();
            if (this.children.size() >= 128 && this.children instanceof Char2ObjectArrayMap) {
                this.children = new Char2ObjectOpenHashMap(this.children);
            }
            this.children.put(ch, n);
        }

        private void init() {
            if (this.children == null) {
                this.children = new Char2ObjectArrayMap();
            }
        }
    }

    public static class NDense<T>
    implements Node<T> {
        IntList data = new IntArrayList();

        @Override
        public void get(TreeSearcher<T> p, IntSet ret, int offset) {
            boolean full;
            boolean bl = full = p.logic == Searcher.Logic.EQUAL;
            if (!full && p.acc.search().length() == offset) {
                this.get(p, ret);
            } else {
                for (int i = 0; i < this.data.size() / 2; ++i) {
                    int ch = this.data.getInt(i * 2);
                    if (!(full ? p.acc.matches(offset, ch) : p.acc.begins(offset, ch))) continue;
                    ret.add(this.data.getInt(i * 2 + 1));
                }
            }
        }

        @Override
        public void get(TreeSearcher<T> p, IntSet ret) {
            for (int i = 0; i < this.data.size() / 2; ++i) {
                ret.add(this.data.getInt(i * 2 + 1));
            }
        }

        @Override
        public Node<T> put(TreeSearcher<T> p, int name, int identifier) {
            if (this.data.size() >= 128) {
                int pattern = this.data.getInt(0);
                NSlice<T> ret = new NSlice<T>(pattern, pattern + this.match(p));
                for (int j = 0; j < this.data.size() / 2; ++j) {
                    ret.put(p, this.data.getInt(j * 2), this.data.getInt(j * 2 + 1));
                }
                ret.put(p, name, identifier);
                return ret;
            }
            this.data.add(name);
            this.data.add(identifier);
            return this;
        }

        private int match(TreeSearcher<T> p) {
            int i = 0;
            while (true) {
                char a = p.strs.get(this.data.getInt(0) + i);
                for (int j = 1; j < this.data.size() / 2; ++j) {
                    char b = p.strs.get(this.data.getInt(j * 2) + i);
                    if (a == b && a != '\u0000') continue;
                    return i;
                }
                ++i;
            }
        }
    }

    public static class NSlice<T>
    implements Node<T> {
        Node<T> exit = new NMap();
        int start;
        int end;

        public NSlice(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public void get(TreeSearcher<T> p, IntSet ret, int offset) {
            this.get(p, ret, offset, 0);
        }

        @Override
        public void get(TreeSearcher<T> p, IntSet ret) {
            this.exit.get(p, ret);
        }

        @Override
        public Node<T> put(TreeSearcher<T> p, int name, int identifier) {
            int length = this.end - this.start;
            int match = p.acc.common(this.start, name, length);
            if (match >= length) {
                this.exit = this.exit.put(p, name + length, identifier);
            } else {
                this.cut(p, this.start + match);
                this.exit = this.exit.put(p, name + match, identifier);
            }
            return this.start == this.end ? this.exit : this;
        }

        private void cut(TreeSearcher<T> p, int offset) {
            NMap insert = new NMap();
            if (offset + 1 == this.end) {
                insert.put(p.strs.get(offset), this.exit);
            } else {
                NSlice<T> half = new NSlice<T>(offset + 1, this.end);
                half.exit = this.exit;
                insert.put(p.strs.get(offset), half);
            }
            this.exit = insert;
            this.end = offset;
        }

        private void get(TreeSearcher<T> p, IntSet ret, int offset, int start) {
            if (this.start + start == this.end) {
                this.exit.get(p, ret, offset);
            } else if (offset == p.acc.search().length()) {
                if (p.logic != Searcher.Logic.EQUAL) {
                    this.exit.get(p, ret);
                }
            } else {
                char ch = p.strs.get(this.start + start);
                p.acc.get(ch, offset).foreach(i -> this.get(p, ret, offset + i, start + 1));
            }
        }
    }

    static interface Node<T> {
        public void get(TreeSearcher<T> var1, IntSet var2, int var3);

        public void get(TreeSearcher<T> var1, IntSet var2);

        public Node<T> put(TreeSearcher<T> var1, int var2, int var3);
    }
}

