/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.asm;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.towdium.jecharacters.asm.ITransformer;
import me.towdium.jecharacters.asm.TransformTarget;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class ConfigurableTransformer
implements ITransformer {
    protected final Map<String, Set<TransformTarget>> targets = new HashMap<String, Set<TransformTarget>>();

    @Override
    public void init(JsonObject config, Set<String> removal) {
        TransformTarget tt;
        String s;
        if (!config.has(this.getConfigOwner())) {
            return;
        }
        JsonObject configObj = config.get(this.getConfigOwner()).getAsJsonObject();
        for (JsonElement target : configObj.get("default").getAsJsonArray()) {
            s = target.getAsString();
            if (removal.contains(s)) continue;
            tt = TransformTarget.of(target.getAsString());
            this.targets.computeIfAbsent(tt.getOwner(), k -> new HashSet()).add(tt);
        }
        for (JsonElement target : configObj.get("additional").getAsJsonArray()) {
            s = target.getAsString();
            if (removal.contains(s)) continue;
            tt = TransformTarget.of(target.getAsString());
            this.targets.computeIfAbsent(tt.getOwner(), k -> new HashSet()).add(tt);
        }
    }

    @Override
    public Set<String> targetClasses() {
        return Collections.unmodifiableSet(this.targets.keySet());
    }

    @Override
    public boolean accept(String className) {
        return this.targets.containsKey(className);
    }

    @Override
    public ClassNode transform(ClassNode node) {
        Set<TransformTarget> targetMethods = this.targets.get(node.name);
        if (targetMethods == null) {
            return node;
        }
        for (MethodNode method : node.methods) {
            for (TransformTarget target : targetMethods) {
                if (!target.matches(node.name, method)) continue;
                this.transformMethod(method);
            }
        }
        return node;
    }

    protected abstract String getConfigOwner();

    protected abstract void transformMethod(MethodNode var1);
}

