/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public final class MaidRayTraceHelper {
    private MaidRayTraceHelper() {
    }

    public static Optional<EntityMaid> rayTraceMaid(Player player, double distance) {
        List maidList = player.f_19853_.m_6249_((Entity)player, player.m_20191_().m_82377_(distance, distance, distance), entity -> entity instanceof EntityMaid && ((EntityMaid)entity).m_21830_((LivingEntity)player));
        for (Entity maid : maidList) {
            if (!maid.m_6084_() || !(maid instanceof EntityMaid) || !MaidRayTraceHelper.isEntityBeLooked(player, maid) || !((EntityMaid)maid).m_21830_((LivingEntity)player)) continue;
            return Optional.of((EntityMaid)maid);
        }
        return Optional.empty();
    }

    private static boolean isEntityBeLooked(Player player, Entity lookEntity) {
        double maxDistanceDeviation;
        Vec3 lookVec = player.m_20154_().m_82541_();
        Vec3 playerAndEntityVec = new Vec3(lookEntity.m_20185_() - player.m_20185_(), lookEntity.m_20191_().f_82289_ + (double)lookEntity.m_20192_() * 2.0 / 3.0 - (player.m_20186_() + (double)player.m_20192_()), lookEntity.m_20189_() - player.m_20189_());
        double playerAndEntityDistance = playerAndEntityVec.m_82553_();
        double cosAngle = lookVec.m_82526_(playerAndEntityVec = playerAndEntityVec.m_82541_());
        return cosAngle > 1.0 - (maxDistanceDeviation = 0.075 / playerAndEntityDistance) && player.m_142582_(lookEntity);
    }
}

