/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public final class ItemsUtil {
    private ItemsUtil() {
    }

    public static void dropEntityItems(Entity entity, IItemHandler itemHandler, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(i);
            ItemStack extractItem = itemHandler.extractItem(i, stackInSlot.m_41613_(), false);
            if (extractItem.m_41619_()) continue;
            entity.m_19983_(extractItem);
        }
    }

    public static void dropEntityItems(Entity entity, IItemHandler itemHandler, int startIndex) {
        ItemsUtil.dropEntityItems(entity, itemHandler, startIndex, itemHandler.getSlots());
    }

    public static void dropEntityItems(Entity entity, IItemHandler itemHandler) {
        ItemsUtil.dropEntityItems(entity, itemHandler, 0, itemHandler.getSlots());
    }

    public static int findStackSlot(IItemHandler handler, Predicate<ItemStack> filter) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!filter.test(stack)) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> getFilterStackSlots(IItemHandler handler, Predicate<ItemStack> filter) {
        IntArrayList slots = new IntArrayList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!filter.test(stack)) continue;
            slots.add(i);
        }
        return slots;
    }

    public static boolean isStackIn(IItemHandler handler, Predicate<ItemStack> filter) {
        return ItemsUtil.findStackSlot(handler, filter) >= 0;
    }

    public static boolean isStackIn(EntityMaid maid, Predicate<ItemStack> filter) {
        return ItemsUtil.findStackSlot((IItemHandler)maid.getAvailableInv(false), filter) >= 0;
    }

    public static ItemStack getStack(IItemHandler handler, Predicate<ItemStack> filter) {
        int slotIndex = ItemsUtil.findStackSlot(handler, filter);
        if (slotIndex >= 0) {
            return handler.getStackInSlot(slotIndex);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getStack(EntityMaid maid, Predicate<ItemStack> filter) {
        return ItemsUtil.getStack((IItemHandler)maid.getAvailableInv(false), filter);
    }

    public static int getBaubleSlotInMaid(EntityMaid maid, IMaidBauble bauble) {
        BaubleItemHandler handler = maid.getMaidBauble();
        for (int i = 0; i < handler.getSlots(); ++i) {
            IMaidBauble baubleIn = handler.getBaubleInSlot(i);
            if (baubleIn != bauble) continue;
            return i;
        }
        return -1;
    }

    public static String getItemId(Item item) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)item);
        Preconditions.checkNotNull((Object)key);
        return key.toString();
    }

    public static ItemStack getItemStack(String itemId) {
        ResourceLocation resourceLocation = new ResourceLocation(itemId);
        Item value = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        Preconditions.checkNotNull((Object)value);
        return new ItemStack((ItemLike)value);
    }

    public static void giveItemToMaid(EntityMaid maid, ItemStack itemStack) {
        CombinedInvWrapper inv = maid.getAvailableInv(false);
        ItemStack stack = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)itemStack, (boolean)false);
        if (!stack.m_41619_()) {
            ItemEntity itemEntity = new ItemEntity(maid.m_9236_(), maid.m_20185_(), maid.m_20186_() + 0.5, maid.m_20189_(), stack);
            maid.f_19853_.m_7967_((Entity)itemEntity);
        }
    }
}

