/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Dist.CLIENT})
public final class EntityCacheUtil {
    public static final Cache<EntityType<?>, Entity> ENTITY_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    public static final Cache<Long, EntityMaid> STATUE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    public static final Cache<ItemStack, EntityMaid> GARAGE_KIT_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private static ResourceKey<Level> dimAt;

    public static void clearMaidDataResidue(EntityMaid maid, boolean clearEquipmentData) {
        maid.f_20917_ = 0;
        maid.f_20916_ = 0;
        maid.f_20919_ = 0;
        maid.m_6853_(true);
        maid.m_21837_(false);
        maid.setMaidBackpackType(BackpackManager.getEmptyBackpack());
        maid.m_6593_((Component)Component.m_237119_());
        if (clearEquipmentData) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                maid.m_8061_(slot, ItemStack.f_41583_);
            }
        }
    }

    @SubscribeEvent
    public static void onChangeDim(EntityJoinLevelEvent event) {
        ResourceKey dim;
        if (event.getLevel().f_46443_ && event.getEntity() == Minecraft.m_91087_().f_91074_ && !(dim = event.getEntity().f_19853_.m_46472_()).equals(dimAt)) {
            dimAt = dim;
            ENTITY_CACHE.invalidateAll();
        }
    }
}

