/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class WirelessIOSlotConfigMessage {
    private static final byte[] EMPTY = new byte[0];
    private final byte[] configData;

    public WirelessIOSlotConfigMessage(byte[] configData) {
        this.configData = configData;
    }

    public WirelessIOSlotConfigMessage() {
        this(EMPTY);
    }

    public static void encode(WirelessIOSlotConfigMessage message, FriendlyByteBuf buf) {
        buf.m_130087_(message.configData);
    }

    public static WirelessIOSlotConfigMessage decode(FriendlyByteBuf buf) {
        return new WirelessIOSlotConfigMessage(buf.m_130052_());
    }

    public static void handle(WirelessIOSlotConfigMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                ItemStack handItem = sender.m_21205_();
                if (handItem.m_41720_() == InitItems.WIRELESS_IO.get()) {
                    if (message.configData.length > 0) {
                        ItemWirelessIO.setSlotConfig(handItem, message.configData);
                    }
                    NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)((ItemWirelessIO)handItem.m_41720_()), buffer -> buffer.m_130055_(handItem));
                }
            });
        }
        context.setPacketHandled(true);
    }
}

