/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.sound.data.MaidAISoundInstance;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class TTSAudioToClientMessage {
    private final int maidId;
    private final byte[] data;

    public TTSAudioToClientMessage(int maidId, byte[] data) {
        this.maidId = maidId;
        this.data = data;
    }

    public static void encode(TTSAudioToClientMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.maidId);
        buf.m_130087_(message.data);
    }

    public static TTSAudioToClientMessage decode(FriendlyByteBuf buf) {
        return new TTSAudioToClientMessage(buf.m_130242_(), buf.m_130052_());
    }

    public static void handle(TTSAudioToClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> TTSAudioToClientMessage.onHandle(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(TTSAudioToClientMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Entity entity = mc.f_91073_.m_6815_(message.maidId);
        if (!(entity instanceof EntityMaid)) {
            return;
        }
        EntityMaid maid = (EntityMaid)entity;
        if (maid.m_6084_()) {
            MaidAISoundInstance instance = new MaidAISoundInstance(maid, message.data);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)instance);
        }
    }
}

