/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SetBeaconPotionMessage {
    private final BlockPos pos;
    private final int potionIndex;

    public SetBeaconPotionMessage(BlockPos pos, int potionIndex) {
        this.pos = pos;
        this.potionIndex = potionIndex;
    }

    public static void encode(SetBeaconPotionMessage message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeInt(message.potionIndex);
    }

    public static SetBeaconPotionMessage decode(FriendlyByteBuf buf) {
        return new SetBeaconPotionMessage(buf.m_130135_(), buf.readInt());
    }

    public static void handle(SetBeaconPotionMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                BlockEntity te;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Level world = sender.m_9236_();
                if (world.m_46749_(message.pos) && (te = world.m_7702_(message.pos)) instanceof TileEntityMaidBeacon) {
                    ((TileEntityMaidBeacon)te).setPotionIndex(message.potionIndex);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

