/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.GomokuToServerMessage;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class GomokuToClientMessage {
    private final BlockPos pos;
    private final int[][] chessData;
    private final Point point;
    private final int count;

    public GomokuToClientMessage(BlockPos pos, int[][] chessData, Point point, int count) {
        this.pos = pos;
        this.chessData = chessData;
        this.point = point;
        this.count = count;
    }

    public static void encode(GomokuToClientMessage message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130130_(message.chessData.length);
        for (int[] row : message.chessData) {
            buf.m_130089_(row);
        }
        buf.m_130130_(message.point.x);
        buf.m_130130_(message.point.y);
        buf.m_130130_(message.point.type);
        buf.m_130130_(message.count);
    }

    public static GomokuToClientMessage decode(FriendlyByteBuf buf) {
        BlockPos blockPos = buf.m_130135_();
        int length = buf.m_130242_();
        int[][] chessData = new int[length][length];
        for (int i = 0; i < length; ++i) {
            chessData[i] = buf.m_130100_();
        }
        Point pointIn = new Point(buf.m_130242_(), buf.m_130242_(), buf.m_130242_());
        int count = buf.m_130242_();
        return new GomokuToClientMessage(blockPos, chessData, pointIn, count);
    }

    public static void handle(GomokuToClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> CompletableFuture.runAsync(() -> GomokuToClientMessage.onHandle(message), Util.m_183991_()));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(GomokuToClientMessage message) {
        Point aiPoint = MaidGomokuAI.getService(message.count).getPoint(message.chessData, message.point);
        int time = (int)(Math.random() * 1250.0) + 250;
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Minecraft.m_91087_().m_18689_(() -> NetworkHandler.CHANNEL.sendToServer((Object)new GomokuToServerMessage(message.pos, aiPoint)));
    }
}

