/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.molang.parser;

import com.github.tartaricacid.touhoulittlemaid.molang.lexer.MolangLexer;
import com.github.tartaricacid.touhoulittlemaid.molang.lexer.Token;
import com.github.tartaricacid.touhoulittlemaid.molang.lexer.TokenKind;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.MolangParser;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ParseException;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.BinaryExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.CallExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.DoubleExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.ExecutionScopeExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.Expression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.IdentifierExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.StatementExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.StringExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.StructAccessExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.TernaryConditionalExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.UnaryExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.Function;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.binding.ObjectBinding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MolangParserImpl
implements MolangParser {
    private static final int PRECEDENCE_QUES = 1400;
    private static final Object UNSET_FLAG = new Object();
    private final MolangLexer lexer;
    private final ObjectBinding binding;
    @Nullable
    private Object current = UNSET_FLAG;

    MolangParserImpl(@NotNull MolangLexer lexer, @NotNull ObjectBinding binding) {
        this.lexer = Objects.requireNonNull(lexer, "lexer");
        this.binding = Objects.requireNonNull(binding, "binding");
    }

    @NotNull
    Expression parseSingle(@NotNull MolangLexer lexer) throws IOException {
        Token token = lexer.current();
        switch (token.kind()) {
            case FLOAT: {
                lexer.next();
                return new DoubleExpression(Double.parseDouble(token.value()));
            }
            case STRING: {
                lexer.next();
                return new StringExpression(token.value());
            }
            case TRUE: {
                lexer.next();
                return DoubleExpression.ONE;
            }
            case FALSE: {
                lexer.next();
                return DoubleExpression.ZERO;
            }
            case LPAREN: {
                lexer.next();
                Expression expression = this.parseCompoundExpression(lexer, 0);
                token = lexer.current();
                if (token.kind() != TokenKind.RPAREN) {
                    throw new ParseException("Non closed expression", lexer.cursor());
                }
                lexer.next();
                return expression;
            }
            case LBRACE: {
                lexer.next();
                ArrayList<Expression> expressions = new ArrayList<Expression>();
                while (true) {
                    expressions.add(this.parseCompoundExpression(lexer, 0));
                    token = lexer.current();
                    if (token.kind() == TokenKind.RBRACE) break;
                    if (token.kind() == TokenKind.EOF) {
                        throw new ParseException("Found the end before the execution scope closing token", lexer.cursor());
                    }
                    if (token.kind() == TokenKind.ERROR) {
                        throw new ParseException("Found an invalid token (error): " + token.value(), lexer.cursor());
                    }
                    if (token.kind() != TokenKind.SEMICOLON) {
                        throw new ParseException("Missing semicolon", lexer.cursor());
                    }
                    lexer.next();
                }
                lexer.next();
                return new ExecutionScopeExpression(expressions);
            }
            case BREAK: {
                lexer.next();
                return new StatementExpression(StatementExpression.Op.BREAK);
            }
            case CONTINUE: {
                lexer.next();
                return new StatementExpression(StatementExpression.Op.CONTINUE);
            }
            case IDENTIFIER: {
                Object lastTarget = this.binding.getProperty(token.value());
                if (lastTarget == null) {
                    throw new ParseException("Failed to get property: " + token.value(), lexer.cursor());
                }
                Expression expr = IdentifierExpression.get(token.value(), lastTarget);
                token = lexer.next();
                if (token.kind() == TokenKind.DOT) {
                    token = lexer.next();
                    if (token.kind() != TokenKind.IDENTIFIER) {
                        throw new ParseException("Unexpected token, expected a valid field token", lexer.cursor());
                    }
                    if (!(lastTarget instanceof ObjectBinding)) {
                        throw new ParseException("Illegal access to : " + token.value(), lexer.cursor());
                    }
                    lastTarget = ((ObjectBinding)lastTarget).getProperty(token.value());
                    if (lastTarget == null) {
                        throw new ParseException("Failed to get property: " + token.value(), lexer.cursor());
                    }
                    expr = IdentifierExpression.get(token.value(), lastTarget);
                    lexer.next();
                }
                return expr;
            }
            case PLUS: {
                lexer.next();
                return this.parseCompoundExpression(lexer, UnaryExpression.Op.PLUS.precedence());
            }
            case SUB: {
                lexer.next();
                return new UnaryExpression(UnaryExpression.Op.ARITHMETICAL_NEGATION, this.parseCompoundExpression(lexer, UnaryExpression.Op.ARITHMETICAL_NEGATION.precedence()));
            }
            case BANG: {
                lexer.next();
                return new UnaryExpression(UnaryExpression.Op.LOGICAL_NEGATION, this.parseCompoundExpression(lexer, UnaryExpression.Op.LOGICAL_NEGATION.precedence()));
            }
            case RETURN: {
                lexer.next();
                return new UnaryExpression(UnaryExpression.Op.RETURN, this.parseCompoundExpression(lexer, UnaryExpression.Op.RETURN.precedence()));
            }
        }
        throw new ParseException("Expected an expression.", lexer.cursor());
    }

    @NotNull
    Expression parseCompoundExpression(@NotNull MolangLexer lexer, int lastPrecedence) throws IOException {
        Expression expr = this.parseSingle(lexer);
        while (true) {
            Expression compoundExpr = this.parseCompound(lexer, expr, lastPrecedence);
            Token current = lexer.current();
            if (current.kind() == TokenKind.EOF || current.kind() == TokenKind.SEMICOLON) {
                return compoundExpr;
            }
            if (compoundExpr == expr) {
                return expr;
            }
            expr = compoundExpr;
        }
    }

    @NotNull
    Expression parseCompound(@NotNull MolangLexer lexer, @NotNull Expression left, int lastPrecedence) throws IOException {
        BinaryExpression.Op op;
        Token current = lexer.current();
        switch (current.kind()) {
            case RPAREN: 
            case EOF: {
                return left;
            }
            case LPAREN: {
                if (left instanceof IdentifierExpression) {
                    lexer.next();
                    ArrayList<Expression> arguments = new ArrayList<Expression>();
                    while (true) {
                        arguments.add(this.parseCompoundExpression(lexer, 0));
                        current = lexer.current();
                        if (current.kind() == TokenKind.EOF) {
                            throw new ParseException("Found EOF before closing RPAREN", null);
                        }
                        if (current.kind() == TokenKind.RPAREN) break;
                        if (current.kind() != TokenKind.COMMA) {
                            throw new ParseException("Expected a comma", lexer.cursor());
                        }
                        lexer.next();
                    }
                    lexer.next();
                    Object target = ((IdentifierExpression)left).target();
                    String name = ((IdentifierExpression)left).name();
                    if (target instanceof Function) {
                        Function func = (Function)target;
                        if (!func.validateArgumentSize(arguments.size())) {
                            throw new ParseException("Function call to \"" + name + "\" has illegal parameter size", null);
                        }
                        return new CallExpression(func, new Function.ArgumentCollection(arguments));
                    }
                    throw new ParseException("\"" + name + "\" is not a function", null);
                }
                if (lastPrecedence >= BinaryExpression.Op.MUL.precedence()) {
                    return left;
                }
                Expression right = this.parseCompoundExpression(lexer, BinaryExpression.Op.MUL.precedence());
                return new BinaryExpression(BinaryExpression.Op.MUL, left, right);
            }
            case QUES: {
                if (lastPrecedence > 1400) {
                    return left;
                }
                lexer.next();
                Expression trueValue = this.parseCompoundExpression(lexer, 1400);
                if (lexer.current().kind() == TokenKind.COLON) {
                    lexer.next();
                    return new TernaryConditionalExpression(left, trueValue, this.parseCompoundExpression(lexer, 1400));
                }
                return new BinaryExpression(BinaryExpression.Op.CONDITIONAL, left, trueValue);
            }
        }
        if (current.kind() == TokenKind.DOT) {
            current = lexer.next();
            if (current.kind() == TokenKind.IDENTIFIER) {
                lexer.next();
                return new StructAccessExpression(left, current.value());
            }
            throw new ParseException("Expect a identifier after struct access operator", lexer.cursor());
        }
        switch (current.kind()) {
            case AMPAMP: {
                op = BinaryExpression.Op.AND;
                break;
            }
            case BARBAR: {
                op = BinaryExpression.Op.OR;
                break;
            }
            case LT: {
                op = BinaryExpression.Op.LT;
                break;
            }
            case LTE: {
                op = BinaryExpression.Op.LTE;
                break;
            }
            case GT: {
                op = BinaryExpression.Op.GT;
                break;
            }
            case GTE: {
                op = BinaryExpression.Op.GTE;
                break;
            }
            case PLUS: {
                op = BinaryExpression.Op.ADD;
                break;
            }
            case SUB: {
                op = BinaryExpression.Op.SUB;
                break;
            }
            case STAR: {
                op = BinaryExpression.Op.MUL;
                break;
            }
            case SLASH: {
                op = BinaryExpression.Op.DIV;
                break;
            }
            case QUESQUES: {
                op = BinaryExpression.Op.NULL_COALESCE;
                break;
            }
            case EQ: {
                op = BinaryExpression.Op.ASSIGN;
                break;
            }
            case EQEQ: {
                op = BinaryExpression.Op.EQ;
                break;
            }
            case BANGEQ: {
                op = BinaryExpression.Op.NEQ;
                break;
            }
            case ARROW: {
                op = BinaryExpression.Op.ARROW;
                break;
            }
            default: {
                return left;
            }
        }
        int precedence = op.precedence();
        if (lastPrecedence >= precedence) {
            return left;
        }
        lexer.next();
        return new BinaryExpression(op, left, this.parseCompoundExpression(lexer, precedence));
    }

    @Override
    @NotNull
    public MolangLexer lexer() {
        return this.lexer;
    }

    @Override
    @Nullable
    public Expression current() {
        if (this.current == UNSET_FLAG) {
            throw new IllegalStateException("No current parsed expression, call next() at least once!");
        }
        return (Expression)this.current;
    }

    @Override
    @Nullable
    public Expression next() throws IOException {
        Expression expr = this.next0();
        this.current = expr;
        return expr;
    }

    @Nullable
    private Expression next0() throws IOException {
        Token token = this.lexer.next();
        if (token.kind() == TokenKind.EOF) {
            return null;
        }
        if (token.kind() == TokenKind.ERROR) {
            throw new ParseException("Found an invalid token (error): " + token.value(), this.cursor());
        }
        Expression expression = this.parseCompoundExpression(this.lexer, -10);
        token = this.lexer.current();
        if (token.kind() != TokenKind.EOF && token.kind() != TokenKind.SEMICOLON) {
            throw new ParseException("Expected a semicolon, but was " + token, this.lexer.cursor());
        }
        return expression;
    }

    @Override
    public void close() throws IOException {
        this.lexer.close();
    }
}

