/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.Cube;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.FaceUv;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.ModelProperties;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.UvFaces;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.UvUnion;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoQuad;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoVertex;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.VectorUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class GeoCube {
    public final List<GeoQuad> quads = new ObjectArrayList(6);
    public final Vector3f size = new Vector3f();

    private GeoCube(double[] size) {
        if (size.length >= 3) {
            this.size.set((float)size[0], (float)size[1], (float)size[2]);
        }
    }

    public static GeoCube createFromPojoCube(Cube cubeIn, ModelProperties properties, Double boneInflate, Boolean mirror) {
        GeoQuad quadDown;
        GeoQuad quadUp;
        GeoQuad quadSouth;
        GeoQuad quadNorth;
        GeoQuad quadEast;
        GeoQuad quadWest;
        GeoCube cube = new GeoCube(cubeIn.getSize());
        UvUnion uvUnion = cubeIn.getUv();
        UvFaces faces = uvUnion.faceUV;
        boolean isBoxUV = uvUnion.isBoxUV;
        double inflate = cubeIn.getInflate() == null ? (boneInflate == null ? 0.0 : boneInflate) : cubeIn.getInflate() / 16.0;
        float textureHeight = properties.getTextureHeight().floatValue();
        float textureWidth = properties.getTextureWidth().floatValue();
        Vec3 size = VectorUtils.fromArray(cubeIn.getSize());
        Vec3 origin = VectorUtils.fromArray(cubeIn.getOrigin());
        origin = new Vec3(-(origin.f_82479_ + size.f_82479_) / 16.0, origin.f_82480_ / 16.0, origin.f_82481_ / 16.0);
        size = size.m_82542_(0.0625, 0.0625, 0.0625);
        Vector3f rotation = VectorUtils.convertDoubleToFloat(VectorUtils.fromArray(cubeIn.getRotation()));
        rotation.mul(-1.0f, -1.0f, 1.0f);
        rotation.set((float)Math.toRadians(rotation.x()), (float)Math.toRadians(rotation.y()), (float)Math.toRadians(rotation.z()));
        Vector3f pivot = VectorUtils.convertDoubleToFloat(VectorUtils.fromArray(cubeIn.getPivot()));
        pivot.mul(-1.0f, 1.0f, 1.0f);
        GeoVertex P13 = new GeoVertex(origin.f_82479_ - inflate, origin.f_82480_ - inflate, origin.f_82481_ - inflate);
        GeoVertex P22 = new GeoVertex(origin.f_82479_ - inflate, origin.f_82480_ - inflate, origin.f_82481_ + size.f_82481_ + inflate);
        GeoVertex P32 = new GeoVertex(origin.f_82479_ - inflate, origin.f_82480_ + size.f_82480_ + inflate, origin.f_82481_ - inflate);
        GeoVertex P42 = new GeoVertex(origin.f_82479_ - inflate, origin.f_82480_ + size.f_82480_ + inflate, origin.f_82481_ + size.f_82481_ + inflate);
        GeoVertex P52 = new GeoVertex(origin.f_82479_ + size.f_82479_ + inflate, origin.f_82480_ - inflate, origin.f_82481_ - inflate);
        GeoVertex P62 = new GeoVertex(origin.f_82479_ + size.f_82479_ + inflate, origin.f_82480_ - inflate, origin.f_82481_ + size.f_82481_ + inflate);
        GeoVertex P72 = new GeoVertex(origin.f_82479_ + size.f_82479_ + inflate, origin.f_82480_ + size.f_82480_ + inflate, origin.f_82481_ - inflate);
        GeoVertex P8 = new GeoVertex(origin.f_82479_ + size.f_82479_ + inflate, origin.f_82480_ + size.f_82480_ + inflate, origin.f_82481_ + size.f_82481_ + inflate);
        if (!isBoxUV) {
            FaceUv west = faces.getWest();
            FaceUv east = faces.getEast();
            FaceUv north = faces.getNorth();
            FaceUv south = faces.getSouth();
            FaceUv up = faces.getUp();
            FaceUv down = faces.getDown();
            quadWest = west == null ? null : new GeoQuad(new GeoVertex[]{P42, P32, P13, P22}, west.getUv(), west.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.WEST);
            quadEast = east == null ? null : new GeoQuad(new GeoVertex[]{P72, P8, P62, P52}, east.getUv(), east.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.EAST);
            quadNorth = north == null ? null : new GeoQuad(new GeoVertex[]{P32, P72, P52, P13}, north.getUv(), north.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.NORTH);
            quadSouth = south == null ? null : new GeoQuad(new GeoVertex[]{P8, P42, P22, P62}, south.getUv(), south.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.SOUTH);
            quadUp = up == null ? null : new GeoQuad(new GeoVertex[]{P42, P8, P72, P32}, up.getUv(), up.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.UP);
            GeoQuad geoQuad = quadDown = down == null ? null : new GeoQuad(new GeoVertex[]{P13, P52, P62, P22}, down.getUv(), down.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.DOWN);
            if (Boolean.TRUE.equals(cubeIn.getMirror()) || Boolean.TRUE.equals(mirror)) {
                quadWest = west == null ? null : new GeoQuad(new GeoVertex[]{P72, P8, P62, P52}, west.getUv(), west.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.WEST);
                quadEast = east == null ? null : new GeoQuad(new GeoVertex[]{P42, P32, P13, P22}, east.getUv(), east.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.EAST);
                quadNorth = north == null ? null : new GeoQuad(new GeoVertex[]{P32, P72, P52, P13}, north.getUv(), north.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.NORTH);
                quadSouth = south == null ? null : new GeoQuad(new GeoVertex[]{P8, P42, P22, P62}, south.getUv(), south.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.SOUTH);
                quadUp = up == null ? null : new GeoQuad(new GeoVertex[]{P13, P52, P62, P22}, up.getUv(), up.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.UP);
                quadDown = down == null ? null : new GeoQuad(new GeoVertex[]{P42, P8, P72, P32}, down.getUv(), down.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.DOWN);
            }
        } else {
            double[] uv = cubeIn.getUv().boxUVCoords;
            Vec3 uvSize = VectorUtils.fromArray(cubeIn.getSize());
            uvSize = new Vec3(Math.floor(uvSize.f_82479_), Math.floor(uvSize.f_82480_), Math.floor(uvSize.f_82481_));
            quadWest = new GeoQuad(new GeoVertex[]{P42, P32, P13, P22}, new double[]{uv[0] + uvSize.f_82481_ + uvSize.f_82479_, uv[1] + uvSize.f_82481_}, new double[]{uvSize.f_82481_, uvSize.f_82480_}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.WEST);
            quadEast = new GeoQuad(new GeoVertex[]{P72, P8, P62, P52}, new double[]{uv[0], uv[1] + uvSize.f_82481_}, new double[]{uvSize.f_82481_, uvSize.f_82480_}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.EAST);
            quadNorth = new GeoQuad(new GeoVertex[]{P32, P72, P52, P13}, new double[]{uv[0] + uvSize.f_82481_, uv[1] + uvSize.f_82481_}, new double[]{uvSize.f_82479_, uvSize.f_82480_}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.NORTH);
            quadSouth = new GeoQuad(new GeoVertex[]{P8, P42, P22, P62}, new double[]{uv[0] + uvSize.f_82481_ + uvSize.f_82479_ + uvSize.f_82481_, uv[1] + uvSize.f_82481_}, new double[]{uvSize.f_82479_, uvSize.f_82480_}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.SOUTH);
            quadUp = new GeoQuad(new GeoVertex[]{P42, P8, P72, P32}, new double[]{uv[0] + uvSize.f_82481_, uv[1]}, new double[]{uvSize.f_82479_, uvSize.f_82481_}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.UP);
            quadDown = new GeoQuad(new GeoVertex[]{P13, P52, P62, P22}, new double[]{uv[0] + uvSize.f_82481_ + uvSize.f_82479_, uv[1] + uvSize.f_82481_}, new double[]{uvSize.f_82479_, -uvSize.f_82481_}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.DOWN);
            if (Boolean.TRUE.equals(cubeIn.getMirror()) || Boolean.TRUE.equals(mirror)) {
                quadWest = new GeoQuad(new GeoVertex[]{P72, P8, P62, P52}, new double[]{uv[0] + uvSize.f_82481_ + uvSize.f_82479_, uv[1] + uvSize.f_82481_}, new double[]{uvSize.f_82481_, uvSize.f_82480_}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.WEST);
                quadEast = new GeoQuad(new GeoVertex[]{P42, P32, P13, P22}, new double[]{uv[0], uv[1] + uvSize.f_82481_}, new double[]{uvSize.f_82481_, uvSize.f_82480_}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.EAST);
                quadNorth = new GeoQuad(new GeoVertex[]{P32, P72, P52, P13}, new double[]{uv[0] + uvSize.f_82481_, uv[1] + uvSize.f_82481_}, new double[]{uvSize.f_82479_, uvSize.f_82480_}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.NORTH);
                quadSouth = new GeoQuad(new GeoVertex[]{P8, P42, P22, P62}, new double[]{uv[0] + uvSize.f_82481_ + uvSize.f_82479_ + uvSize.f_82481_, uv[1] + uvSize.f_82481_}, new double[]{uvSize.f_82479_, uvSize.f_82480_}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.SOUTH);
                quadUp = new GeoQuad(new GeoVertex[]{P42, P8, P72, P32}, new double[]{uv[0] + uvSize.f_82481_, uv[1]}, new double[]{uvSize.f_82479_, uvSize.f_82481_}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.UP);
                quadDown = new GeoQuad(new GeoVertex[]{P13, P52, P62, P22}, new double[]{uv[0] + uvSize.f_82481_ + uvSize.f_82479_, uv[1] + uvSize.f_82481_}, new double[]{uvSize.f_82479_, -uvSize.f_82481_}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.DOWN);
            }
        }
        if (quadWest != null) {
            cube.quads.add(quadWest);
        }
        if (quadEast != null) {
            cube.quads.add(quadEast);
        }
        if (quadNorth != null) {
            cube.quads.add(quadNorth);
        }
        if (quadSouth != null) {
            cube.quads.add(quadSouth);
        }
        if (quadUp != null) {
            cube.quads.add(quadUp);
        }
        if (quadDown != null) {
            cube.quads.add(quadDown);
        }
        PoseStack poseStack = new PoseStack();
        poseStack.m_272245_(new Quaternionf().rotateZYX(rotation.z(), rotation.y(), rotation.x()), pivot.x() / 16.0f, pivot.y() / 16.0f, pivot.z() / 16.0f);
        for (GeoQuad quad : cube.quads) {
            quad.normal.mul((Matrix3fc)poseStack.m_85850_().m_252943_());
            for (GeoVertex vertex : quad.vertices) {
                Vector4f vec4 = new Vector4f(vertex.position.x, vertex.position.y, vertex.position.z, 1.0f);
                vec4.mul((Matrix4fc)poseStack.m_85850_().m_252922_());
                vertex.position.set(vec4.x, vec4.y, vec4.z);
            }
        }
        return cube;
    }
}

